/*
 * Decompiled with CFR 0.152.
 */
package io.github.jcohy.gradle.version;

import java.util.regex.Pattern;
import org.gradle.api.Project;
import org.springframework.util.Assert;

public enum ReleaseStatus {
    SNAPSHOT,
    PRERELEASE,
    GENERAL_AVAILABILITY;

    private static final Pattern PRERELEASE_PATTERN;
    private static final String SNAPSHOT_SUFFIX = "SNAPSHOT";

    public static ReleaseStatus ofProject(Project project) {
        String version = project.getVersion().toString();
        Assert.notNull((Object)version, (String)"Version must not be null");
        if (version.endsWith(SNAPSHOT_SUFFIX)) {
            return SNAPSHOT;
        }
        if (PRERELEASE_PATTERN.matcher(version).matches()) {
            return PRERELEASE;
        }
        return GENERAL_AVAILABILITY;
    }

    static {
        PRERELEASE_PATTERN = Pattern.compile("[A-Za-z0-9\\.\\-]+?(M|RC)\\d+");
    }
}

