/*
 * Decompiled with CFR 0.152.
 */
package io.github.jcohy.gradle.version;

import io.github.jcohy.gradle.version.ReleaseStatus;

public enum Repository {
    SNAPSHOT("jcohy-snapshots", "Jcohy-Snapshots", "http://192.168.11.230:8081/repository/snapshot", true),
    MILESTONE("jcohy-milestones", "Jcohy-Milestones", "http://192.168.11.230:8081/repository/milestone", false),
    RELEASE("jochy-releases", "Jcohy-Releases", "http://192.168.11.230:8081/repository/releases", false);

    private final String id;
    private final String name;
    private final String url;
    private final boolean snapshotsEnabled;

    private Repository(String id, String name, String url, Boolean snapshotsEnabled) {
        this.id = id;
        this.name = name;
        this.url = url;
        this.snapshotsEnabled = snapshotsEnabled;
    }

    public static Repository of(ReleaseStatus status) {
        switch (status) {
            case GENERAL_AVAILABILITY: {
                return RELEASE;
            }
            case PRERELEASE: {
                return MILESTONE;
            }
            case SNAPSHOT: {
                return SNAPSHOT;
            }
        }
        return RELEASE;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isSnapshotsEnabled() {
        return this.snapshotsEnabled;
    }
}

