/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeemv.springboot.vuejs;

import io.github.jeemv.springboot.vuejs.beans.RawObject;
import io.github.jeemv.springboot.vuejs.parts.VueComputeds;
import io.github.jeemv.springboot.vuejs.parts.VueData;
import io.github.jeemv.springboot.vuejs.parts.VueDirective;
import io.github.jeemv.springboot.vuejs.parts.VueDirectives;
import io.github.jeemv.springboot.vuejs.parts.VueFilter;
import io.github.jeemv.springboot.vuejs.parts.VueFilters;
import io.github.jeemv.springboot.vuejs.parts.VueHook;
import io.github.jeemv.springboot.vuejs.parts.VueMethod;
import io.github.jeemv.springboot.vuejs.parts.VueMethods;
import io.github.jeemv.springboot.vuejs.parts.VueWatcher;
import io.github.jeemv.springboot.vuejs.parts.VueWatchers;
import io.github.jeemv.springboot.vuejs.utilities.Http;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractVueJS {
    protected VueData data = new VueData();
    protected VueMethods methods = new VueMethods();
    protected VueComputeds computed = new VueComputeds();
    protected VueWatchers watchers = new VueWatchers();
    protected VueDirectives directives = new VueDirectives();
    protected VueFilters filters = new VueFilters();
    protected Map<String, VueHook> hooks = new HashMap<String, VueHook>();

    public void addData(String key, Object value) {
        this.data.put(key, value);
    }

    public void addDataRaw(String key, String value) {
        this.data.put(key, new RawObject(value));
    }

    public void addData(String key) {
        this.data.put(key, "");
    }

    public VueMethod addMethod(String name) {
        return this.addMethod(name, "", new String[0]);
    }

    public VueMethod addMethod(String name, String body) {
        return this.addMethod(name, body, new String[0]);
    }

    public VueMethod addMethod(String name, String body, String ... params) {
        return this.methods.add(name, body, params);
    }

    public void addComputed(String name, String get, String set) {
        this.computed.add(name, get, set);
    }

    public void addComputed(String name, String get) {
        this.addComputed(name, get, null);
    }

    public void attachWatcher(String variableName, String methodName, boolean deep, boolean immediate) {
        this.watchers.add(variableName, methodName, deep, immediate);
    }

    public void attachWatcher(String variableName, String methodName, boolean deep) {
        this.watchers.add(variableName, methodName, deep, false);
    }

    public void attachWatcher(String variableName, String methodName) {
        this.watchers.add(variableName, methodName, false, false);
    }

    public void attachImmediateWatcher(String variableName, String methodName) {
        this.watchers.add(variableName, methodName, false, true);
    }

    public void attachDeepWatcher(String variableName, String methodName) {
        this.watchers.add(variableName, methodName, true, false);
    }

    public void addWatcher(String variableName, boolean deep, boolean immediate, String ... handlers) {
        VueWatcher vueWatcher = this.watchers.addHandlers(variableName, handlers);
        vueWatcher.setDeep(deep);
        vueWatcher.setImmediate(immediate);
    }

    public void addWatcher(String variableName, boolean deep, String ... handlers) {
        this.addWatcher(variableName, deep, false, handlers);
    }

    public void addWatcher(String variableName, String ... handlers) {
        this.addWatcher(variableName, false, false, handlers);
    }

    public void addImmediateWatcher(String variableName, String ... handlers) {
        this.addWatcher(variableName, false, true, handlers);
    }

    public void addDeepWatcher(String variableName, String ... handlers) {
        this.addWatcher(variableName, true, false, handlers);
    }

    protected void addHook(String name, String body) {
        this.hooks.put(name, new VueHook(body));
    }

    public VueDirective addDirective(String name) {
        return this.directives.add(name);
    }

    public VueDirective addDirective(String name, String shortHand) {
        return this.directives.add(name, shortHand);
    }

    public VueFilter addFilter(String name, String body, String ... args) {
        return this.filters.add(name, body, args);
    }

    public void onBeforeCreate(String body) {
        this.addHook("beforeCreate", body);
    }

    public void onCreated(String body) {
        this.addHook("created", body);
    }

    public void onBeforeMount(String body) {
        this.addHook("beforeMount", body);
    }

    public void onMounted(String body) {
        this.addHook("mounted", body);
    }

    public void onBeforeUpdate(String body) {
        this.addHook("beforeUpdate", body);
    }

    public void onUpdated(String body) {
        this.addHook("updated", body);
    }

    public void onUpdatedNextTick(String body) {
        this.addHook("updated", "this.$nextTick(function () {" + body + "})");
    }

    public void onBeforeDestroy(String body) {
        this.addHook("beforeDestroy", body);
    }

    public void onDestroyed(String body) {
        this.addHook("destroyed", body);
    }

    public Map<String, VueHook> getHooks() {
        return this.hooks;
    }

    public String set(String data, String value) {
        return String.format("this.%s=%s;", data, value);
    }

    public String get(String data) {
        return "this." + data;
    }

    public String cloneOriginalData(String from, String dataTo) {
        return String.format("this.%s={ ...%s};this.%s.original=%s;", dataTo, from, dataTo, from);
    }

    public String assignOriginal(String originalData, String value) {
        return String.format("Object.assign(this.%s.original,%s);", originalData, value);
    }

    public String assignOriginalWithHttp(String originalData) {
        return String.format("Object.assign(this.%s.original,%s);", originalData, Http.RESPONSE_DATA);
    }

    public abstract String getScript();

    public VueData getData() {
        return this.data;
    }

    public VueMethods getMethods() {
        return this.methods;
    }

    public VueComputeds getComputed() {
        return this.computed;
    }

    public VueDirectives getDirectives() {
        return this.directives;
    }

    public String toString() {
        return this.getScript();
    }

    public VueWatchers getWatchers() {
        return this.watchers;
    }

    public VueFilters getFilters() {
        return this.filters;
    }
}

