/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeemv.springboot.vuejs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.github.jeemv.springboot.vuejs.AbstractVueJS;
import io.github.jeemv.springboot.vuejs.components.VueComponent;
import io.github.jeemv.springboot.vuejs.configuration.VueJSAutoConfiguration;
import io.github.jeemv.springboot.vuejs.configuration.VueJSProperties;
import io.github.jeemv.springboot.vuejs.configuration.VueVersion;
import io.github.jeemv.springboot.vuejs.configuration.versions.Vue2Version;
import io.github.jeemv.springboot.vuejs.configuration.versions.Vue3Version;
import io.github.jeemv.springboot.vuejs.parts.AbstractVueComposition;
import io.github.jeemv.springboot.vuejs.parts.VueDirective;
import io.github.jeemv.springboot.vuejs.parts.VueFilter;
import io.github.jeemv.springboot.vuejs.utilities.Http;
import io.github.jeemv.springboot.vuejs.utilities.JsUtils;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VueJS
extends AbstractVueJS {
    protected String el;
    protected String[] delimiters;
    protected boolean useAxios;
    protected boolean vuetify;
    protected String vueVersion;
    @JsonIgnore
    protected String beforeMountScript;
    protected Map<String, VueComponent> globalComponents;
    protected Map<String, AbstractVueComposition> globalElements;
    @Autowired(required=false)
    protected VueJSAutoConfiguration vueJSAutoConfiguration;
    private final Logger logger;

    protected VueVersion getVueVersion(String globalScript) {
        if (this.isVue2()) {
            return new Vue2Version(this.useAxios, globalScript + this.beforeMountScript);
        }
        return new Vue3Version(this.useAxios, globalScript + this.beforeMountScript);
    }

    @PostConstruct
    public void init() {
        if (null == this.vueJSAutoConfiguration) {
            this.logger.debug("VueJS configuration not yet loaded");
        } else {
            VueJSProperties vueJSProperties = this.vueJSAutoConfiguration.getVueJSProperties();
            this.setDelimiters(vueJSProperties.getPrefix(), vueJSProperties.getPostfix());
            if (vueJSProperties.isUseAxios()) {
                this.useAxios = true;
            }
            if (vueJSProperties.isVuetify()) {
                this.vuetify = true;
            }
            Http.RESPONSE_DATA = vueJSProperties.getHttpData();
            this.el = vueJSProperties.getEl();
            this.vueVersion = vueJSProperties.getVueVersion();
        }
    }

    public VueJS(String element) {
        this.el = element;
        this.globalComponents = new HashMap<String, VueComponent>();
        this.globalElements = new HashMap<String, AbstractVueComposition>();
        this.vueVersion = "3.*";
        this.beforeMountScript = "";
        this.logger = LoggerFactory.getLogger(VueJS.class);
    }

    public VueJS() {
        this("v-app");
    }

    public void setDelimiters(String start, String end) {
        this.delimiters = new String[]{start, end};
    }

    @Override
    public String getScript() {
        StringBuilder globalScript = new StringBuilder();
        StringBuilder script = new StringBuilder();
        try {
            for (Map.Entry<String, VueComponent> entry : this.globalComponents.entrySet()) {
                globalScript.append(entry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.globalElements.entrySet()) {
                globalScript.append(((AbstractVueComposition)entry.getValue()).getScript());
            }
            VueVersion vueVersion = this.getVueVersion(globalScript.toString());
            script.append(vueVersion.generateVueJSInstance(JsUtils.objectToJSON(this), this.el));
            return "<script>" + script + "</script>";
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return script.toString();
        }
    }

    public VueComponent addGlobalComponent(String name) {
        VueComponent component = new VueComponent(name);
        this.globalComponents.put(name, component);
        return component;
    }

    public VueDirective addGlobalDirective(String name) {
        VueDirective directive = new VueDirective(name);
        this.globalElements.put(name, directive);
        return directive;
    }

    public VueFilter addGlobalFilter(String name, String body, String ... args) {
        VueFilter filter = new VueFilter(name, body, args);
        this.globalElements.put(name, filter);
        return filter;
    }

    public String getEl() {
        return this.el;
    }

    public String[] getDelimiters() {
        return this.delimiters;
    }

    public void setEl(String el) {
        this.el = el;
    }

    public void setUseAxios(boolean useAxios) {
        this.useAxios = useAxios;
    }

    public boolean isVuetify() {
        return this.vuetify;
    }

    public boolean isVue2() {
        return this.vueVersion.startsWith("2");
    }

    public void addBeforeMountScript(String script) {
        this.beforeMountScript = this.beforeMountScript + script;
    }

    public void loadAndAddBeforeMountScript(String filename) throws IOException {
        this.beforeMountScript = this.beforeMountScript + JsUtils.loadJsFile(filename);
    }
}

