/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeemv.springboot.vuejs.components;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.github.jeemv.springboot.vuejs.parts.VueMethod;
import io.github.jeemv.springboot.vuejs.utilities.JsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class VueProp {
    private static final String[] jsTypes = new String[]{"String", "Number", "Boolean", "Array", "Object", "Date", "Function", "Symbol"};
    private String name;
    private List<String> types;
    private boolean required;
    private Object defaultValue;
    private VueMethod validator;

    public VueProp(String name, String type, boolean required, Object defaultValue) {
        this.name = name;
        this.setTypes(type);
        this.required = required;
        this.defaultValue = defaultValue;
    }

    public VueProp(String name, String type, boolean required) {
        this(name, type, required, null);
    }

    public VueProp(String name, String type) {
        this(name, type, false, null);
    }

    public VueProp(String name) {
        this(name, null, false, null);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public void addType(String type) {
        if (type != null && !"".equals(type) && Arrays.asList(jsTypes).contains(type) && !this.types.contains(type)) {
            this.types.add(type);
        }
    }

    public void setTypes(String ... types) {
        this.types = new ArrayList<String>();
        for (String type : types) {
            this.addType(type);
        }
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public VueMethod getValidator() {
        return this.validator;
    }

    public void setValidator(String validatorBody) {
        this.validator = new VueMethod(validatorBody, "value");
    }

    public String toString() {
        try {
            return JsUtils.objectToJSON(this);
        }
        catch (JsonProcessingException e) {
            return "";
        }
    }

    public boolean isSimple() {
        return !this.required && (this.types == null || this.types.size() == 0) && this.defaultValue == null && this.validator == null;
    }
}

