/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeemv.springboot.vuejs.parts;

import io.github.jeemv.springboot.vuejs.parts.AbstractVueComposition;
import io.github.jeemv.springboot.vuejs.parts.VueMethod;
import io.github.jeemv.springboot.vuejs.parts.VueMethods;

public class VueDirective
extends AbstractVueComposition {
    protected VueMethods methods;
    protected VueMethod shortHand;

    public VueDirective() {
        this.methods = new VueMethods();
    }

    public VueDirective(String name) {
        super(name);
        this.methods = new VueMethods();
    }

    public VueDirective(String name, String shortHand) {
        super(name);
        this.setShortHand(shortHand);
    }

    public void setShortHand(String shortHand) {
        this.shortHand = new VueMethod(shortHand, "el", "binding", "vnode");
    }

    public VueDirective onBind(String body) {
        return this.on("bind", body);
    }

    public VueDirective onUpdate(String body) {
        this.methods.add("update", body, "el", "binding", "vnode", "oldVnode");
        return this;
    }

    public VueDirective onComponentUpdated(String body) {
        this.methods.add("componentUpdated", body, "el", "binding", "vnode", "oldVnode");
        return this;
    }

    public VueDirective onInserted(String body) {
        return this.on("inserted", body);
    }

    public VueDirective onUnbind(String body) {
        return this.on("unbind", body);
    }

    protected VueDirective on(String event, String body) {
        this.methods.add(event, body, "el", "binding", "vnode");
        return this;
    }

    public String toString() {
        if (this.shortHand instanceof VueMethod) {
            return this.shortHand.toString();
        }
        return this.methods.toString();
    }

    @Override
    public String getType() {
        return "directive";
    }

    public void setDeep() {
        this.methods.addProperty("deep", true);
    }
}

