/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeemv.springboot.vuejs.parts;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class VueMethod {
    private static final Pattern RTRIM = Pattern.compile(";+$");
    private List<String> params;
    private String body;
    private String name;

    public VueMethod(String body, String ... params) {
        this.body = body;
        this.params = Arrays.asList(params);
    }

    public List<String> getParams() {
        return this.params;
    }

    public VueMethod setParams(List<String> params) {
        this.params = params;
        return this;
    }

    public VueMethod addParams(String ... params) {
        this.params.addAll(Arrays.asList(params));
        return this;
    }

    public String getBody() {
        return this.body;
    }

    public VueMethod setBody(String body) {
        this.body = body;
        return this;
    }

    public String toString() {
        String parameters = String.join((CharSequence)",", this.params);
        Object thisName = "";
        if (this.name != null && !"".equals(this.name)) {
            thisName = " " + this.name;
        }
        return "function " + (String)thisName + "(" + parameters + "){" + this.body + "}";
    }

    public String getName() {
        return this.name;
    }

    public VueMethod setName(String name) {
        this.name = name;
        return this;
    }

    public VueMethod addBodyParts(String ... body) {
        StringBuilder sb = new StringBuilder();
        for (String line : body) {
            sb.append(RTRIM.matcher(line).replaceFirst(""));
            sb.append(";");
        }
        this.body = this.body + sb.toString();
        return this;
    }

    public VueMethod addBody(String body) {
        this.body = this.body + RTRIM.matcher(body).replaceFirst("") + ";";
        return this;
    }
}

