/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeemv.springboot.vuejs.parts;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.github.jeemv.springboot.vuejs.parts.VueMethod;
import io.github.jeemv.springboot.vuejs.utilities.JsUtils;
import java.util.ArrayList;
import java.util.List;

public class VueWatcher {
    private List<VueMethod> handlers;
    private String method = null;
    private boolean deep = false;
    private boolean immediate = false;

    public VueWatcher(String methodName) {
        this.method = methodName;
    }

    public VueWatcher(String ... methodsBody) {
        this.handlers = new ArrayList<VueMethod>();
        for (String body : methodsBody) {
            VueMethod vm = new VueMethod(body, "val", "oldVal");
            this.handlers.add(vm);
            if (methodsBody.length <= 1) continue;
            vm.setName("handler" + this.handlers.size());
        }
    }

    public String toString() {
        Object result = "";
        if (this.method != null) {
            result = "'" + this.method + "'";
        } else if (this.handlers != null) {
            if (this.handlers.size() == 1) {
                result = this.handlers.get(0).toString();
            } else {
                try {
                    result = JsUtils.objectToJSON(this.handlers);
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                    return "";
                }
            }
        }
        if (this.immediate || this.deep) {
            return "{handler: " + (String)result + ",deep: " + this.deep + ",immediate: " + this.immediate + "}";
        }
        return result;
    }

    public void setDeep(boolean deep) {
        this.deep = deep;
    }

    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
    }
}

