/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeemv.springboot.vuejs.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.github.jeemv.springboot.vuejs.VueJS;
import io.github.jeemv.springboot.vuejs.utilities.Serialization;
import java.io.IOException;

public class VueJSSerializer
extends StdSerializer<VueJS> {
    private static final long serialVersionUID = 1L;

    public VueJSSerializer() {
        this(null);
    }

    protected VueJSSerializer(Class<VueJS> t) {
        super(t);
    }

    public void serialize(VueJS value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        if (value.isVue2()) {
            gen.writeStringField("el", value.getEl());
        }
        if (value.isVuetify()) {
            gen.writeFieldName("vuetify");
            gen.writeRawValue("new Vuetify()");
        }
        gen.writeArrayFieldStart("delimiters");
        for (String arg : value.getDelimiters()) {
            gen.writeString(arg);
        }
        gen.writeEndArray();
        Serialization.serializeVueElements(value, gen, provider);
        gen.writeEndObject();
    }
}

