/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeemv.springboot.vuejs.utilities;

public class JsPart {
    private StringBuilder content;

    public JsPart() {
        this.content = new StringBuilder();
    }

    public JsPart(String jsScript) {
        this.content = new StringBuilder(jsScript);
    }

    public JsPart add(String jsScript) {
        this.content.append(jsScript);
        return this;
    }

    public JsPart addElements(String ... jsScripts) {
        for (String jsScript : jsScripts) {
            this.content.append(jsScript);
        }
        return this;
    }

    public JsPart set(String variable, String value) {
        this.content.append(variable + "=" + value + ";");
        return this;
    }

    public JsPart let(String variable, String value) {
        this.content.append("let " + variable + "=" + value + ";");
        return this;
    }

    public JsPart constante(String variable, String value) {
        this.content.append("const " + variable + "=" + value + ";");
        return this;
    }

    public JsPart var(String variable, String value) {
        this.content.append("var " + variable + "=" + value + ";");
        return this;
    }

    public JsPart ifStatement(String condition, String ... jsScripts) {
        this.content.append("if(" + condition + "){");
        this.addElements(jsScripts);
        this.content.append("}");
        return this;
    }

    public JsPart elseStatement(String ... jsScripts) {
        this.content.append("else{");
        this.addElements(jsScripts);
        this.content.append("}");
        return this;
    }

    public JsPart elseIfStatement(String condition, String ... jsScripts) {
        this.content.append("else if(" + condition + "){");
        this.addElements(jsScripts);
        this.content.append("}");
        return this;
    }

    public JsPart forStatement(String variable, String condition, String increment, String ... jsScripts) {
        this.content.append("for(" + variable + ";" + condition + ";" + increment + "){");
        this.addElements(jsScripts);
        this.content.append("}");
        return this;
    }

    public JsPart whileStatement(String condition, String ... jsScripts) {
        this.content.append("while(" + condition + "){");
        this.addElements(jsScripts);
        this.content.append("}");
        return this;
    }

    public JsPart doWhileStatement(String condition, String ... jsScripts) {
        this.content.append("do{");
        this.addElements(jsScripts);
        this.content.append("}while(" + condition + ");");
        return this;
    }

    public JsPart switchStatement(String variable, String ... jsScripts) {
        this.content.append("switch(" + variable + "){");
        this.addElements(jsScripts);
        this.content.append("}");
        return this;
    }

    public JsPart caseStatement(String condition, String ... jsScripts) {
        this.content.append("case " + condition + ":");
        this.addElements(jsScripts);
        return this;
    }

    public JsPart defaultStatement(String ... jsScripts) {
        this.content.append("default:");
        this.addElements(jsScripts);
        return this;
    }

    public JsPart forEachStatement(String array, String ... jsScripts) {
        this.content.append(array + ".forEach(it=>{");
        this.addElements(jsScripts);
        this.content.append("}");
        return this;
    }

    public JsPart forEachStatement(String array, String variable, String ... jsScripts) {
        this.content.append(array + ".forEach(" + variable + "=>{");
        this.addElements(jsScripts);
        this.content.append("}");
        return this;
    }

    public JsPart forEachStatement(String array, String variable, String index, String ... jsScripts) {
        this.content.append(array + ".forEach((" + variable + "," + index + ")=>{");
        this.addElements(jsScripts);
        this.content.append("}");
        return this;
    }

    public JsPart tryStatement(String ... jsScripts) {
        this.content.append("try{");
        this.addElements(jsScripts);
        this.content.append("}");
        return this;
    }

    public JsPart catchStatement(String variable, String ... jsScripts) {
        this.content.append("catch(" + variable + "){");
        this.addElements(jsScripts);
        this.content.append("}");
        return this;
    }

    public JsPart finallyStatement(String ... jsScripts) {
        this.content.append("finally{");
        this.addElements(jsScripts);
        this.content.append("}");
        return this;
    }

    public JsPart function(String name, String ... jsScripts) {
        this.content.append("function " + name + "(){");
        this.addElements(jsScripts);
        this.content.append("}");
        return this;
    }

    public JsPart function(String name, String variables, String ... jsScripts) {
        this.content.append("function " + name + "(" + variables + "){");
        this.addElements(jsScripts);
        this.content.append("}");
        return this;
    }

    public String toString() {
        return this.content.toString();
    }

    public static JsPart instance() {
        return new JsPart();
    }

    public static JsPart instance(String jsScript) {
        return new JsPart(jsScript);
    }
}

