/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeemv.springboot.vuejs.utilities;

public class JsonHelper {
    private String[] keys;
    private String[] values;
    private int pos;
    private String quote = "'";

    public JsonHelper(String ... keys) {
        this.setKeys(keys);
    }

    private String quoteValue(String value) {
        return this.quote + value + this.quote;
    }

    public JsonHelper setKeys(String ... keys) {
        this.keys = keys;
        return this;
    }

    public JsonHelper setValues(String ... values) {
        this.values = values;
        return this;
    }

    public String asArray() {
        StringBuilder result = new StringBuilder();
        result.append('[');
        int limit = this.values.length;
        String prefix = "";
        while (this.pos < limit) {
            result.append(prefix + this.asObject());
            prefix = ",";
        }
        result.append(']');
        return result.toString();
    }

    public String asObject() {
        int i;
        StringBuilder result = new StringBuilder();
        result.append('{');
        int nb = this.keys.length;
        int limit = this.values.length;
        String prefix = "";
        for (i = 0; i < nb && i + this.pos < limit; ++i) {
            result.append(prefix + this.keys[i] + ":" + this.quoteValue(this.values[i + this.pos]));
            prefix = ",";
        }
        result.delete(result.length() - 1, result.length());
        this.pos += i;
        result.append('}');
        return result.toString();
    }
}

