/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeemv.springboot.vuejs.utilities.resources;

import io.github.jeemv.springboot.vuejs.utilities.resources.JsResourceElement;
import io.github.jeemv.springboot.vuejs.utilities.resources.JsResourceLoader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavascriptMultiModulesResource {
    public static String moduleSequenceStart = "//";
    public static String moduleSequenceEnd = "//";
    private Map<String, JsResourceElement> jsResourceElements = new HashMap<String, JsResourceElement>();
    private String jsContent;

    private String getModuleCode(String moduleName) throws Exception {
        Pattern pattern = Pattern.compile(Pattern.quote(moduleSequenceStart) + "(?:.*?)" + moduleName + "(?:.*?)" + Pattern.quote("\r\n") + "(.*?)" + Pattern.quote("\r\n" + moduleSequenceEnd) + "(?:.*?)" + moduleName, 32);
        Matcher matcher = pattern.matcher(this.jsContent);
        if (matcher.find()) {
            String s = matcher.group(1);
            Pattern p = Pattern.compile("(?i)^(" + Pattern.quote("(function() {") + ")+");
            Matcher m = p.matcher(s);
            if (m.find()) {
                s = m.replaceAll("");
                Pattern pl = Pattern.compile("(?i)(" + Pattern.quote("})();") + ")$");
                Matcher ml = pl.matcher(s);
                if (ml.find()) {
                    s = ml.replaceAll("");
                } else {
                    throw new Exception("The module " + moduleName + " contains malformed scripts!");
                }
            }
            return s;
        }
        throw new Exception("module " + moduleName + "not found!");
    }

    public JsResourceElement getModule(String moduleName) {
        if (!this.jsResourceElements.containsKey(moduleName)) {
            this.jsResourceElements.put(moduleName, new JsResourceElement());
        }
        return this.jsResourceElements.get(moduleName);
    }

    public String parseContent(String moduleName) throws Exception {
        JsResourceElement element = this.getModule(moduleName);
        element.setJsContent(this.getModuleCode(moduleName));
        return element.parseContent();
    }

    public void loadFile(String filename) throws IOException {
        JsResourceLoader loader = new JsResourceLoader();
        this.jsContent = loader.loadFile(filename);
    }

    public static JavascriptMultiModulesResource create(String filename) throws IOException {
        JavascriptMultiModulesResource jsFile = new JavascriptMultiModulesResource();
        jsFile.loadFile(filename);
        return jsFile;
    }
}

