/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeemv.springboot.vuejs.utilities.resources;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class JsResourceElement {
    private String jsContent;
    private Map<String, Object> variables;

    public JsResourceElement() {
        this(new HashMap<String, Object>());
    }

    public JsResourceElement(Map<String, Object> variables) {
        this.variables = variables;
    }

    public Object put(String name, Object value) {
        return this.variables.put(name, value);
    }

    public void addVariables(Object[][] keyValues) {
        for (Object[] array : keyValues) {
            if (array.length != 2) continue;
            this.variables.put("" + array[0], array[1]);
        }
    }

    public void addVariables(String jsonString) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Map map = (Map)mapper.readValue(jsonString, (TypeReference)new TypeReference<Map<String, Object>>(){});
        for (String k : map.keySet()) {
            this.variables.put(k, map.get(k));
        }
    }

    public void addVariables(Object o) throws IOException {
        this.addVariables(new ObjectMapper().writeValueAsString(o));
    }

    public String parseContent() {
        String res = this.jsContent;
        for (String k : this.variables.keySet()) {
            Object v = this.variables.get(k);
            res = res.replaceAll("\\$\\{" + k + "\\}", "" + v);
        }
        return res;
    }

    public void setJsContent(String jsContent) {
        this.jsContent = jsContent;
    }
}

