/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdversions;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-release-pom", defaultPhase=LifecyclePhase.PACKAGE)
public class GenerateReleasePomMojo
extends AbstractMojo {
    private static final String RELEASE_POM = "release.pom";
    @Parameter(property="revision", defaultValue="99999-SNAPSHOT")
    String revision;
    @Parameter(property="sha1", defaultValue="99999-SNAPSHOT")
    String sha1;
    @Parameter(property="changelist", defaultValue="99999-SNAPSHOT")
    String changelist;
    @Component
    MavenProject project;

    public void execute() throws MojoExecutionException {
        try {
            String pomText = new String(Files.readAllBytes(this.project.getFile().toPath()));
            File output = new File(this.project.getFile().getParentFile(), RELEASE_POM);
            Files.write(output.toPath(), this.replaceVariables(pomText).getBytes(), new OpenOption[0]);
            this.project.setFile(output);
        }
        catch (IOException e) {
            throw new MojoExecutionException("failed up create release pom file!", (Exception)e);
        }
    }

    private String replaceVariables(String pomText) {
        return pomText.replace("${revision}", this.revision).replace("${sha1}", this.sha1).replace("${changelist}", this.changelist);
    }
}

