/*
 * Decompiled with CFR 0.152.
 */
package kafka.context;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import kafka.context.Context;
import kafka.context.PasswordHelper;

public class ContextHelper {
    static final ObjectMapper json = new ObjectMapper();

    public static Path baseDir() throws IOException {
        String homePath = System.getProperty("user.home");
        if (homePath.isBlank()) {
            throw new IllegalStateException("Can't find user's home. ${HOME} is empty");
        }
        Path home = Path.of(homePath, ".kafka");
        if (!Files.isDirectory(home, new LinkOption[0])) {
            System.err.println("Contexts directory doesn't exist, creating one...");
            Files.createDirectories(home, new FileAttribute[0]);
        }
        return home;
    }

    public static <C extends Context> Map<String, C> from(Path contextPath, Function<JsonNode, C> from) throws IOException {
        JsonNode tree = json.readTree(Files.readAllBytes(contextPath));
        if (!tree.isArray()) {
            throw new IllegalArgumentException("JSON is not an array");
        }
        ArrayNode array = (ArrayNode)tree;
        HashMap<String, Context> contexts = new HashMap<String, Context>(array.size());
        for (JsonNode node : array) {
            Context context = (Context)from.apply(node);
            contexts.put(context.name(), context);
        }
        return contexts;
    }

    public static PasswordHelper passwordHelper() {
        try {
            Path saltPath = ContextHelper.baseDir().resolve(".salt");
            if (!Files.exists(saltPath, new LinkOption[0])) {
                String salt = PasswordHelper.generateKey();
                Files.writeString(saltPath, (CharSequence)salt, new OpenOption[0]);
                return new PasswordHelper(salt);
            }
            String salt = Files.readString(saltPath);
            return new PasswordHelper(salt);
        }
        catch (IOException e) {
            throw new IllegalStateException("Password helper not loading", e);
        }
    }
}

