/*
 * Decompiled with CFR 0.152.
 */
package kafka.context;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import kafka.context.KafkaContexts;
import kafka.context.auth.KafkaAuth;

public record KafkaCluster(String bootstrapServers, KafkaAuth auth) {
    static KafkaCluster parse(JsonNode cluster) {
        return new KafkaCluster(cluster.get("bootstrapServers").textValue(), KafkaAuth.parse(cluster.get("auth")));
    }

    public JsonNode printJson() {
        ObjectNode node = KafkaContexts.json.createObjectNode().put("bootstrapServers", this.bootstrapServers);
        node.set("auth", this.auth.printJson());
        return node;
    }
}

