/*
 * Decompiled with CFR 0.152.
 */
package kafka.context;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Properties;
import kafka.context.Context;
import kafka.context.ContextHelper;
import kafka.context.KafkaCluster;
import kafka.context.KafkaContexts;
import kafka.context.auth.KafkaAuth;
import kafka.context.auth.KafkaUsernamePasswordAuth;
import org.apache.kafka.common.security.auth.SecurityProtocol;

public record KafkaContext(String name, KafkaCluster cluster) implements Context
{
    static KafkaContext from(JsonNode node) {
        String name = node.get("name").textValue();
        return new KafkaContext(name, KafkaCluster.parse(node.get("cluster")));
    }

    public JsonNode printJson() {
        ObjectNode node = KafkaContexts.json.createObjectNode().put("name", this.name);
        node.set("cluster", this.cluster.printJson());
        return node;
    }

    @Override
    public Properties properties() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.cluster.bootstrapServers());
        switch (this.cluster.auth().type()) {
            case SASL_PLAIN: {
                props.put("security.protocol", SecurityProtocol.SASL_SSL.name);
                props.put("sasl.mechanism", "PLAIN");
                KafkaUsernamePasswordAuth auth = (KafkaUsernamePasswordAuth)this.cluster.auth();
                props.setProperty("sasl.jaas.config", "org.apache.kafka.common.security.plain.PlainLoginModule required username=\"%s\" password=\"%s\";".formatted(auth.username(), ContextHelper.passwordHelper().decrypt(auth.password())));
                break;
            }
        }
        return props;
    }

    @Override
    public String kcat() {
        return switch (this.cluster.auth().type()) {
            case KafkaAuth.AuthType.SASL_PLAIN -> "kcat -b %s -X security.protocol=SASL_SSL -X sasl.mechanisms=PLAIN \\\n -X sasl.username=$KAFKA_USERNAME -X sasl.password=$KAFKA_PASSWORD \\\n -X api.version.request=true ".formatted(this.cluster.bootstrapServers());
            default -> "kcat -b %s ".formatted(this.cluster.bootstrapServers());
        };
    }

    @Override
    public String env(boolean includeAuth) {
        return switch (this.cluster.auth().type()) {
            case KafkaAuth.AuthType.SASL_PLAIN -> {
                if (includeAuth) {
                    yield "export KAFKA_BOOTSTRAP_SERVERS=%s\nexport KAFKA_USERNAME=%s\nexport KAFKA_PASSWORD=%s".formatted(this.cluster.bootstrapServers(), ((KafkaUsernamePasswordAuth)this.cluster.auth()).username(), ContextHelper.passwordHelper().decrypt(((KafkaUsernamePasswordAuth)this.cluster.auth()).password()));
                }
                yield "export KAFKA_BOOTSTRAP_SERVERS=%s".formatted(this.cluster.bootstrapServers());
            }
            default -> "export KAFKA_BOOTSTRAP_SERVERS=%s".formatted(this.cluster.bootstrapServers());
        };
    }

    KafkaContext withName(String newName) {
        return new KafkaContext(newName, this.cluster);
    }
}

