/*
 * Decompiled with CFR 0.152.
 */
package kafka.context;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import kafka.context.ContextHelper;
import kafka.context.Contexts;
import kafka.context.KafkaCluster;
import kafka.context.KafkaContext;
import kafka.context.auth.KafkaNoAuth;

public final class KafkaContexts
implements Contexts<KafkaContext> {
    static final ObjectMapper json = new ObjectMapper();
    public static final String CONTEXT_FILENAME = "kafka.json";
    public static final KafkaCluster CONTEXT_DEFAULT = new KafkaCluster("localhost:9092", new KafkaNoAuth());
    private final Map<String, KafkaContext> contextMap;

    KafkaContexts(Map<String, KafkaContext> contextMap) {
        this.contextMap = contextMap;
    }

    public static KafkaContexts load() throws IOException {
        return KafkaContexts.load(ContextHelper.baseDir());
    }

    public static KafkaContexts load(Path baseDir) throws IOException {
        Path contextPath = baseDir.resolve(CONTEXT_FILENAME);
        if (!Files.isRegularFile(contextPath, new LinkOption[0])) {
            System.err.println("Kafka Content configuration file doesn't exist, creating one...");
            Files.write(contextPath, KafkaContexts.createDefault().serialize(), new OpenOption[0]);
        }
        return new KafkaContexts(ContextHelper.from(contextPath, KafkaContext::from));
    }

    private static KafkaContexts createDefault() {
        KafkaContext ctx = new KafkaContext("default", CONTEXT_DEFAULT);
        return new KafkaContexts(Map.of(ctx.name(), ctx));
    }

    @Override
    public void save(Path dir) throws IOException {
        Files.write(dir.resolve(CONTEXT_FILENAME), this.serialize(), new OpenOption[0]);
    }

    @Override
    public String names() throws JsonProcessingException {
        return json.writeValueAsString(this.contextMap.keySet());
    }

    @Override
    public void add(KafkaContext ctx) {
        this.contextMap.put(ctx.name(), ctx);
    }

    @Override
    public void rename(String oldName, String newName) {
        KafkaContext ctx = this.contextMap.remove(oldName);
        this.contextMap.put(newName, ctx.withName(newName));
    }

    @Override
    public KafkaContext get(String name) {
        return this.contextMap.get(name);
    }

    @Override
    public KafkaContext getDefault() {
        return this.contextMap.get("default");
    }

    @Override
    public boolean has(String name) {
        return this.contextMap.containsKey(name);
    }

    @Override
    public void remove(String name) {
        this.contextMap.remove(name);
    }

    @Override
    public String printNamesAndAddresses() throws JsonProcessingException {
        ObjectNode node = json.createObjectNode();
        this.contextMap.forEach((k, v) -> node.put(k, v.cluster().bootstrapServers()));
        return json.writeValueAsString((Object)node);
    }

    @Override
    public byte[] serialize() throws IOException {
        try {
            ArrayNode array = json.createArrayNode();
            for (KafkaContext ctx : this.contextMap.values()) {
                array.add(ctx.printJson());
            }
            return json.writeValueAsBytes((Object)array);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        KafkaContexts that = (KafkaContexts)obj;
        return Objects.equals(this.contextMap, that.contextMap);
    }

    public int hashCode() {
        return Objects.hash(this.contextMap);
    }

    public String toString() {
        return "KafkaContexts[contextMap=" + this.contextMap + "]";
    }
}

