/*
 * Decompiled with CFR 0.152.
 */
package kafka.context.auth;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import kafka.context.auth.KafkaNoAuth;
import kafka.context.auth.KafkaUsernamePasswordAuth;

public interface KafkaAuth {
    public AuthType type();

    public static KafkaAuth parse(JsonNode auth) {
        AuthType type = AuthType.valueOf(auth.get("type").textValue());
        return switch (type) {
            case AuthType.SASL_PLAIN -> new KafkaUsernamePasswordAuth(type, auth.get("username").textValue(), auth.get("password").textValue());
            default -> new KafkaNoAuth();
        };
    }

    default public JsonNode printJson() {
        return new ObjectMapper().createObjectNode().put("type", this.type().name());
    }

    public static enum AuthType {
        PLAINTEXT,
        SASL_PLAIN;

    }
}

