/*
 * Decompiled with CFR 0.152.
 */
package kafka.context.auth;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import kafka.context.ContextHelper;
import kafka.context.auth.KafkaAuth;

public record KafkaUsernamePasswordAuth(KafkaAuth.AuthType authType, String username, String password) implements KafkaAuth
{
    public static KafkaUsernamePasswordAuth build(KafkaAuth.AuthType authType, String username, String password) {
        return new KafkaUsernamePasswordAuth(authType, username, ContextHelper.passwordHelper().encrypt(password));
    }

    @Override
    public KafkaAuth.AuthType type() {
        return this.authType;
    }

    @Override
    public JsonNode printJson() {
        ObjectNode node = (ObjectNode)KafkaAuth.super.printJson();
        return node.put("username", this.username).put("password", this.password);
    }
}

