/*
 * Decompiled with CFR 0.152.
 */
package kafka.context.sr;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Properties;
import kafka.context.Context;
import kafka.context.ContextHelper;
import kafka.context.sr.SchemaRegistryCluster;
import kafka.context.sr.SchemaRegistryContexts;
import kafka.context.sr.auth.HttpUsernamePasswordAuth;
import kafka.context.sr.auth.SchemaRegistryAuth;

public record SchemaRegistryContext(String name, SchemaRegistryCluster cluster) implements Context
{
    static SchemaRegistryContext from(JsonNode node) {
        String name = node.get("name").textValue();
        return new SchemaRegistryContext(name, SchemaRegistryCluster.parse(node.get("cluster")));
    }

    public JsonNode printJson() {
        ObjectNode node = SchemaRegistryContexts.json.createObjectNode().put("name", this.name);
        node.set("cluster", this.cluster.printJson());
        return node;
    }

    @Override
    public Properties properties() {
        Properties props = new Properties();
        props.put("schema.registry.url", this.cluster.urls());
        switch (this.cluster.auth().type()) {
            case BASIC_AUTH: {
                props.put("basic.auth.credentials.source", "USER_INFO");
                HttpUsernamePasswordAuth auth = (HttpUsernamePasswordAuth)this.cluster.auth();
                props.put("basic.auth.user.info", "%s:%s".formatted(auth.username(), ContextHelper.passwordHelper().decrypt(auth.password())));
                break;
            }
        }
        return props;
    }

    @Override
    public String kcat() {
        String urls = this.cluster().urls();
        String https = "https://";
        return switch (this.cluster.auth().type()) {
            default -> throw new IncompatibleClassChangeError();
            case SchemaRegistryAuth.AuthType.BASIC_AUTH -> "\\\n -r https://$SCHEMA_REGISTRY_USERNAME:$SCHEMA_REGISTRY_PASSWORD@" + urls.substring("https://".length()) + " -s value=avro";
            case SchemaRegistryAuth.AuthType.NO_AUTH -> "\\\n -r " + urls + " -s value=avro";
        };
    }

    @Override
    public String env(boolean includeAuth) {
        String urls = this.cluster().urls();
        return switch (this.cluster.auth().type()) {
            default -> throw new IncompatibleClassChangeError();
            case SchemaRegistryAuth.AuthType.BASIC_AUTH -> {
                if (includeAuth) {
                    yield "export SCHEMA_REGISTRY_URL=%s\nexport SCHEMA_REGISTRY_USERNAME=%s\nexport SCHEMA_REGISTRY_PASSWORD=%s".formatted(urls, ((HttpUsernamePasswordAuth)this.cluster.auth()).username(), ContextHelper.passwordHelper().decrypt(((HttpUsernamePasswordAuth)this.cluster.auth()).password()));
                }
                yield "export SCHEMA_REGISTRY_URL=%s".formatted(urls);
            }
            case SchemaRegistryAuth.AuthType.NO_AUTH -> "export SCHEMA_REGISTRY_URL=%s".formatted(urls);
        };
    }

    SchemaRegistryContext withName(String newName) {
        return new SchemaRegistryContext(newName, this.cluster);
    }
}

