/*
 * Decompiled with CFR 0.152.
 */
package kafka.context.sr;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import kafka.context.ContextHelper;
import kafka.context.Contexts;
import kafka.context.sr.SchemaRegistryCluster;
import kafka.context.sr.SchemaRegistryContext;
import kafka.context.sr.auth.HttpNoAuth;

public final class SchemaRegistryContexts
implements Contexts<SchemaRegistryContext> {
    static final ObjectMapper json = new ObjectMapper();
    public static final String CONTEXT_FILENAME = "schema-registry.json";
    public static final SchemaRegistryCluster CONTEXT_DEFAULT = new SchemaRegistryCluster("http://localhost:8081", new HttpNoAuth());
    private final Map<String, SchemaRegistryContext> contextMap;

    SchemaRegistryContexts(Map<String, SchemaRegistryContext> contextMap) {
        this.contextMap = contextMap;
    }

    public static SchemaRegistryContexts load() throws IOException {
        return SchemaRegistryContexts.load(ContextHelper.baseDir());
    }

    public static SchemaRegistryContexts load(Path baseDir) throws IOException {
        Path contextPath = baseDir.resolve(CONTEXT_FILENAME);
        if (!Files.isRegularFile(contextPath, new LinkOption[0])) {
            System.err.println("Schema registry contexts configuration file doesn't exist, creating one...");
            Files.write(contextPath, SchemaRegistryContexts.createDefault().serialize(), new OpenOption[0]);
        }
        return new SchemaRegistryContexts(ContextHelper.from(contextPath, SchemaRegistryContext::from));
    }

    private static SchemaRegistryContexts createDefault() {
        SchemaRegistryContext ctx = new SchemaRegistryContext("default", CONTEXT_DEFAULT);
        return new SchemaRegistryContexts(Map.of(ctx.name(), ctx));
    }

    @Override
    public void save(Path dir) throws IOException {
        Files.write(dir.resolve(CONTEXT_FILENAME), this.serialize(), new OpenOption[0]);
    }

    @Override
    public String names() throws JsonProcessingException {
        return json.writeValueAsString(this.contextMap.keySet());
    }

    @Override
    public void add(SchemaRegistryContext ctx) {
        this.contextMap.put(ctx.name(), ctx);
    }

    @Override
    public void rename(String oldName, String newName) {
        SchemaRegistryContext ctx = this.contextMap.remove(oldName);
        this.contextMap.put(newName, ctx.withName(newName));
    }

    @Override
    public SchemaRegistryContext get(String name) {
        return this.contextMap.get(name);
    }

    @Override
    public SchemaRegistryContext getDefault() {
        return this.get("default");
    }

    @Override
    public boolean has(String contextName) {
        return this.contextMap.containsKey(contextName);
    }

    @Override
    public void remove(String name) {
        this.contextMap.remove(name);
    }

    @Override
    public String printNamesAndAddresses() throws JsonProcessingException {
        ObjectNode node = json.createObjectNode();
        this.contextMap.forEach((k, v) -> node.put(k, v.cluster().urls()));
        return json.writeValueAsString((Object)node);
    }

    @Override
    public byte[] serialize() throws IOException {
        try {
            ArrayNode array = json.createArrayNode();
            for (SchemaRegistryContext ctx : this.contextMap.values()) {
                array.add(ctx.printJson());
            }
            return json.writeValueAsBytes((Object)array);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SchemaRegistryContexts that = (SchemaRegistryContexts)obj;
        return Objects.equals(this.contextMap, that.contextMap);
    }

    public int hashCode() {
        return Objects.hash(this.contextMap);
    }

    public String toString() {
        return "SchemaRegistryContexts[contextMap=" + this.contextMap + "]";
    }
}

