/*
 * Decompiled with CFR 0.152.
 */
package kafka.context.sr.auth;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.PasswordAuthentication;
import kafka.context.ContextHelper;
import kafka.context.sr.auth.SchemaRegistryAuth;

public record HttpUsernamePasswordAuth(SchemaRegistryAuth.AuthType authType, String username, String password) implements SchemaRegistryAuth
{
    public static SchemaRegistryAuth build(SchemaRegistryAuth.AuthType authType, String username, String password) {
        return new HttpUsernamePasswordAuth(authType, username, ContextHelper.passwordHelper().encrypt(password));
    }

    public PasswordAuthentication passwordAuth() {
        return new PasswordAuthentication(this.username, ContextHelper.passwordHelper().decrypt(this.password).toCharArray());
    }

    @Override
    public SchemaRegistryAuth.AuthType type() {
        return this.authType;
    }

    @Override
    public JsonNode printJson() {
        ObjectNode node = (ObjectNode)SchemaRegistryAuth.super.printJson();
        return node.put("username", this.username).put("password", this.password);
    }
}

