/*
 * Decompiled with CFR 0.152.
 */
package kafka.context.sr.auth;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import kafka.context.sr.auth.HttpNoAuth;
import kafka.context.sr.auth.HttpUsernamePasswordAuth;

public interface SchemaRegistryAuth {
    public AuthType type();

    public static SchemaRegistryAuth parse(JsonNode auth) {
        AuthType type = AuthType.valueOf(auth.get("type").textValue());
        return switch (type) {
            case AuthType.BASIC_AUTH -> new HttpUsernamePasswordAuth(type, auth.get("username").textValue(), auth.get("password").textValue());
            default -> new HttpNoAuth();
        };
    }

    default public JsonNode printJson() {
        return new ObjectMapper().createObjectNode().put("type", this.type().name());
    }

    public static enum AuthType {
        NO_AUTH,
        BASIC_AUTH;

    }
}

