/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyliao.liveeventbus.processor.gson;

import android.os.Bundle;
import com.jeremyliao.liveeventbus.ipc.core.Processor;
import com.jeremyliao.liveeventbus.processor.gson.converter.GsonConverter;
import com.jeremyliao.liveeventbus.processor.gson.converter.JsonConverter;

public class GsonProcessor
implements Processor {
    private final JsonConverter jsonConverter = new GsonConverter();

    public boolean writeToBundle(Bundle bundle, Object value) {
        String json = this.jsonConverter.toJson(value);
        bundle.putString("leb_ipc_value", json);
        bundle.putString("leb_ipc_class_name", value.getClass().getCanonicalName());
        return true;
    }

    public Object createFromBundle(Bundle bundle) throws ClassNotFoundException {
        Class<?> classType;
        String json;
        block2: {
            json = bundle.getString("leb_ipc_value");
            String className = bundle.getString("leb_ipc_class_name");
            classType = null;
            try {
                classType = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                int last = className.lastIndexOf(46);
                if (last == -1) break block2;
                String pn = className.substring(0, last);
                String cn = className.substring(last + 1);
                classType = Class.forName(pn + "$" + cn);
            }
        }
        return this.jsonConverter.fromJson(json, classType);
    }
}

