/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.ghsa;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.jeremylong.ghsa.CVSS;
import io.github.jeremylong.ghsa.CWEs;
import io.github.jeremylong.ghsa.Identifier;
import io.github.jeremylong.ghsa.Reference;
import io.github.jeremylong.ghsa.Severity;
import io.github.jeremylong.ghsa.Vulnerabilities;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"databaseId", "description", "ghsaId", "id", "identifiers", "notificationsPermalink", "origin", "permalink", "publishedAt", "references", "severity", "summary", "updatedAt", "vulnerabilities", "cvss", "cwes", "withdrawnAt"})
public class SecurityAdvisory {
    @JsonProperty(value="databaseId")
    private int databaseId;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="ghsaId")
    private String ghsaId;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="identifiers")
    private List<Identifier> identifiers;
    @JsonProperty(value="notificationsPermalink")
    private String notificationsPermalink;
    @JsonProperty(value="origin")
    private String origin;
    @JsonProperty(value="permalink")
    private String permalink;
    @JsonProperty(value="publishedAt")
    @JsonFormat(pattern="uuuu-MM-dd'T'HH:mm:ssX", timezone="UTC")
    private ZonedDateTime publishedAt;
    @JsonProperty(value="references")
    private List<Reference> references;
    @JsonProperty(value="severity")
    private Severity severity;
    @JsonProperty(value="summary")
    private String summary;
    @JsonProperty(value="updatedAt")
    @JsonFormat(pattern="uuuu-MM-dd'T'HH:mm:ssX", timezone="UTC")
    private ZonedDateTime updatedAt;
    @JsonProperty(value="withdrawnAt")
    @JsonFormat(pattern="uuuu-MM-dd'T'HH:mm:ssX", timezone="UTC")
    private ZonedDateTime withdrawnAt;
    @JsonProperty(value="cvss")
    private CVSS cvss;
    @JsonProperty(value="cwes")
    private CWEs cwes;
    @JsonProperty(value="vulnerabilities")
    private Vulnerabilities vulnerabilities;

    public int getDatabaseId() {
        return this.databaseId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getGhsaId() {
        return this.ghsaId;
    }

    public String getId() {
        return this.id;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="I prefer to suppress these FindBugs warnings")
    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    public String getNotificationsPermalink() {
        return this.notificationsPermalink;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getPermalink() {
        return this.permalink;
    }

    public ZonedDateTime getPublishedAt() {
        return this.publishedAt;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="I prefer to suppress these FindBugs warnings")
    public List<Reference> getReferences() {
        return this.references;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getSummary() {
        return this.summary;
    }

    public ZonedDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public ZonedDateTime getWithdrawnAt() {
        return this.withdrawnAt;
    }

    public CVSS getCvss() {
        return this.cvss;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="I prefer to suppress these FindBugs warnings")
    public CWEs getCwes() {
        return this.cwes;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="I prefer to suppress these FindBugs warnings")
    public Vulnerabilities getVulnerabilities() {
        return this.vulnerabilities;
    }

    public String toString() {
        return "SecurityAdvisory{databaseId=" + this.databaseId + ", description='" + this.description + '\'' + ", ghsaId='" + this.ghsaId + '\'' + ", id='" + this.id + '\'' + ", identifiers=" + this.identifiers + ", notificationsPermalink='" + this.notificationsPermalink + '\'' + ", origin='" + this.origin + '\'' + ", permalink='" + this.permalink + '\'' + ", publishedAt=" + this.publishedAt + ", references=" + this.references + ", severity=" + (Object)((Object)this.severity) + ", summary='" + this.summary + '\'' + ", updatedAt=" + this.updatedAt + ", withdrawnAt=" + this.withdrawnAt + ", cvss=" + this.cvss + ", cwes=" + this.cwes + ", vulnerabilities=" + this.vulnerabilities + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityAdvisory that = (SecurityAdvisory)o;
        return this.databaseId == that.databaseId && Objects.equals(this.description, that.description) && Objects.equals(this.ghsaId, that.ghsaId) && Objects.equals(this.id, that.id) && Objects.equals(this.identifiers, that.identifiers) && Objects.equals(this.notificationsPermalink, that.notificationsPermalink) && Objects.equals(this.origin, that.origin) && Objects.equals(this.permalink, that.permalink) && Objects.equals(this.publishedAt, that.publishedAt) && Objects.equals(this.references, that.references) && this.severity == that.severity && Objects.equals(this.summary, that.summary) && Objects.equals(this.updatedAt, that.updatedAt) && Objects.equals(this.withdrawnAt, that.withdrawnAt) && Objects.equals(this.cvss, that.cvss) && Objects.equals(this.cwes, that.cwes) && Objects.equals(this.vulnerabilities, that.vulnerabilities);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.databaseId, this.description, this.ghsaId, this.id, this.identifiers, this.notificationsPermalink, this.origin, this.permalink, this.publishedAt, this.references, this.severity, this.summary, this.updatedAt, this.withdrawnAt, this.cvss, this.cwes, this.vulnerabilities});
    }
}

