/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.ghsa;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.jeremylong.ghsa.PageInfo;
import io.github.jeremylong.ghsa.RateLimit;
import io.github.jeremylong.ghsa.SecurityAdvisory;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
class SecurityAdvisoryResponse {
    @JsonProperty(value="data")
    private Data data;

    SecurityAdvisoryResponse() {
    }

    public RateLimit getRateLimit() {
        return this.data.rateLimit;
    }

    public SecurityAdvisory getSecurityAdvisory() {
        return this.data.securityAdvisory;
    }

    public String toString() {
        if (this.data == null) {
            return "";
        }
        return this.data.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityAdvisoryResponse that = (SecurityAdvisoryResponse)o;
        return Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class SecurityAdvisories {
        @JsonProperty(value="nodes")
        private List<SecurityAdvisory> nodes;
        @JsonProperty(value="totalCount")
        private int totalCount;
        @JsonProperty(value="pageInfo")
        private PageInfo pageInfo;

        SecurityAdvisories() {
        }

        public String toString() {
            return "Advisories{nodes=" + this.nodes + ", totalCount=" + this.totalCount + ", pageInfo=" + this.pageInfo + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SecurityAdvisories that = (SecurityAdvisories)o;
            return this.totalCount == that.totalCount && Objects.equals(this.nodes, that.nodes) && Objects.equals(this.pageInfo, that.pageInfo);
        }

        public int hashCode() {
            return Objects.hash(this.nodes, this.totalCount, this.pageInfo);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Data {
        @JsonProperty(value="rateLimit")
        private RateLimit rateLimit;
        @JsonProperty(value="securityAdvisory")
        private SecurityAdvisory securityAdvisory;

        Data() {
        }

        public String toString() {
            return "Data{rateLimit=" + this.rateLimit + ", securityAdvisory=" + this.securityAdvisory + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Data data = (Data)o;
            return Objects.equals(this.rateLimit, data.rateLimit) && Objects.equals(this.securityAdvisory, data.securityAdvisory);
        }

        public int hashCode() {
            return Objects.hash(this.rateLimit, this.securityAdvisory);
        }
    }
}

