/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.ghsa;

public enum Severity {
    CRITICAL("CRITICAL"),
    HIGH("HIGH"),
    LOW("LOW"),
    MODERATE("MODERATE");

    private final String value;

    private Severity(String graphQlValue) {
        this.value = graphQlValue;
    }

    public static Severity fromValue(String value) {
        if (value == null) {
            return null;
        }
        for (Severity e : Severity.values()) {
            if (!e.value().equals(value)) continue;
            return e;
        }
        throw new IllegalArgumentException("No Severity exists with '" + value + "' as a value");
    }

    public String value() {
        return this.value;
    }
}

