/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.ghsa;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.github.jeremylong.ghsa.Package;
import io.github.jeremylong.ghsa.PackageVersion;
import io.github.jeremylong.ghsa.Severity;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"severity", "updatedAt", "firstPatchedVersion", "vulnerableVersionRange", "package"})
public class Vulnerability {
    @JsonProperty(value="node", access=JsonProperty.Access.WRITE_ONLY)
    private VulnerabilityRecord node;

    @JsonProperty(value="firstPatchedVersion")
    public PackageVersion getFirstPatchedVersion() {
        if (this.node == null) {
            return null;
        }
        return this.node.firstPatchedVersion;
    }

    @JsonProperty(value="firstPatchedVersion")
    void setFirstPatchedVersion(PackageVersion packageVersion) {
        if (this.node == null) {
            this.node = new VulnerabilityRecord();
        }
        this.node.firstPatchedVersion = packageVersion;
    }

    @JsonProperty(value="package")
    public Package getPackage() {
        if (this.node == null) {
            return null;
        }
        return this.node.pkg;
    }

    @JsonProperty(value="package")
    void setPackage(Package pkg) {
        if (this.node == null) {
            this.node = new VulnerabilityRecord();
        }
        this.node.pkg = pkg;
    }

    @JsonProperty(value="severity")
    public Severity getSeverity() {
        if (this.node == null) {
            return null;
        }
        return this.node.severity;
    }

    @JsonProperty(value="severity")
    void setSeverity(Severity severity) {
        if (this.node == null) {
            this.node = new VulnerabilityRecord();
        }
        this.node.severity = severity;
    }

    @JsonProperty(value="updatedAt")
    public ZonedDateTime getUpdatedAt() {
        if (this.node == null) {
            return null;
        }
        return this.node.updatedAt;
    }

    @JsonProperty(value="updatedAt")
    void setUpdatedAt(ZonedDateTime updatedAt) {
        if (this.node == null) {
            this.node = new VulnerabilityRecord();
        }
        this.node.updatedAt = updatedAt;
    }

    @JsonProperty(value="vulnerableVersionRange")
    public String getVulnerableVersionRange() {
        if (this.node == null) {
            return null;
        }
        return this.node.vulnerableVersionRange;
    }

    @JsonProperty(value="vulnerableVersionRange")
    void setVulnerableVersionRange(String range) {
        if (this.node == null) {
            this.node = new VulnerabilityRecord();
        }
        this.node.vulnerableVersionRange = range;
    }

    public String toString() {
        return "Vulnerability[" + this.node + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vulnerability that = (Vulnerability)o;
        return Objects.equals(this.node, that.node);
    }

    public int hashCode() {
        return Objects.hash(this.node);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class VulnerabilityRecord {
        @JsonProperty(value="firstPatchedVersion")
        private PackageVersion firstPatchedVersion;
        @JsonProperty(value="package")
        private Package pkg;
        @JsonProperty(value="severity")
        private Severity severity;
        @JsonProperty(value="updatedAt")
        private ZonedDateTime updatedAt;
        @JsonProperty(value="vulnerableVersionRange")
        private String vulnerableVersionRange;

        VulnerabilityRecord() {
        }

        public String toString() {
            return "VulnerabilityRecord{firstPatchedVersion=" + this.firstPatchedVersion + ", pkg=" + this.pkg + ", severity=" + (Object)((Object)this.severity) + ", updatedAt=" + this.updatedAt + ", vulnerableVersionRange='" + this.vulnerableVersionRange + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VulnerabilityRecord that = (VulnerabilityRecord)o;
            return Objects.equals(this.firstPatchedVersion, that.firstPatchedVersion) && Objects.equals(this.pkg, that.pkg) && this.severity == that.severity && Objects.equals(this.updatedAt, that.updatedAt) && Objects.equals(this.vulnerableVersionRange, that.vulnerableVersionRange);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.firstPatchedVersion, this.pkg, this.severity, this.updatedAt, this.vulnerableVersionRange});
        }
    }
}

