/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.nvdlib;

import io.github.jeremylong.nvdlib.NvdCveApi;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NvdCveApiBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(NvdCveApiBuilder.class);
    private final List<NameValuePair> filters = new ArrayList<NameValuePair>();
    private String apiKey;
    private String endpoint;
    private int resultsPerPage;
    private long delay;
    private int threadCount = 1;
    private int maxPageCount = 0;

    private NvdCveApiBuilder() {
    }

    public static NvdCveApiBuilder aNvdCveApi() {
        return new NvdCveApiBuilder();
    }

    public NvdCveApiBuilder withApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public NvdCveApiBuilder withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public NvdCveApiBuilder withDelay(long milliseconds) {
        this.delay = milliseconds;
        return this;
    }

    public NvdCveApiBuilder withThreadCount(int count) {
        this.threadCount = count;
        return this;
    }

    public NvdCveApiBuilder withMaxPageCount(int count) {
        this.maxPageCount = count;
        return this;
    }

    public NvdCveApiBuilder withResultsPerPage(int resultsPerPage) {
        if (resultsPerPage > 0 && resultsPerPage <= 2000) {
            this.resultsPerPage = resultsPerPage;
        } else {
            LOG.warn("Invalid results per page - must be between 1 and 2000: {}", (Object)resultsPerPage);
        }
        return this;
    }

    public NvdCveApiBuilder withFilter(String filter, String value) {
        this.filters.add((NameValuePair)new BasicNameValuePair(filter, value));
        return this;
    }

    public NvdCveApiBuilder withFilter(Filter filter, String value) {
        this.filters.add((NameValuePair)new BasicNameValuePair(filter.toParameterName(), value));
        return this;
    }

    public NvdCveApiBuilder withFilter(BooleanFilter filter) {
        this.filters.add((NameValuePair)new BasicNameValuePair(filter.toParameterName(), null));
        return this;
    }

    public NvdCveApiBuilder withLastModifiedFilter(LocalDateTime utcStartDate, LocalDateTime utcEndDate) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ssX");
        this.filters.add((NameValuePair)new BasicNameValuePair("lastModStartDate", utcStartDate.atOffset(ZoneOffset.UTC).format(dtf)));
        this.filters.add((NameValuePair)new BasicNameValuePair("lastModEndDate", utcEndDate.atOffset(ZoneOffset.UTC).format(dtf)));
        return this;
    }

    public NvdCveApiBuilder withPublishedDateFilter(LocalDateTime utcStartDate, LocalDateTime utcEndDate) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ssX");
        this.filters.add((NameValuePair)new BasicNameValuePair("pubStartDate", utcStartDate.atOffset(ZoneOffset.UTC).format(dtf)));
        this.filters.add((NameValuePair)new BasicNameValuePair("pubEndDate", utcEndDate.atOffset(ZoneOffset.UTC).format(dtf)));
        return this;
    }

    public NvdCveApiBuilder withCvssV2SeverityFilter(CvssV2Severity severity) {
        this.withFilter("cvssV2Severity", severity.toString());
        return this;
    }

    public NvdCveApiBuilder withCvssV3SeverityFilter(CvssV3Severity severity) {
        this.withFilter("cvssV3Severity", severity.toString());
        return this;
    }

    public NvdCveApi build() {
        NvdCveApi client = this.delay > 0L ? new NvdCveApi(this.apiKey, this.endpoint, this.delay, this.threadCount, this.maxPageCount) : new NvdCveApi(this.apiKey, this.endpoint, this.threadCount, this.maxPageCount);
        if (!this.filters.isEmpty()) {
            client.setFilters(this.filters);
        }
        if (this.resultsPerPage > 0) {
            client.setResultsPerPage(this.resultsPerPage);
        }
        return client;
    }

    public static enum CvssV3Severity {
        LOW,
        MEDIUM,
        HIGH,
        CRITICAL;

    }

    public static enum CvssV2Severity {
        LOW,
        MEDIUM,
        HIGH;

    }

    public static enum BooleanFilter {
        HAS_CERT_ALERTS,
        HAS_CERT_NOTES,
        HAS_KEV,
        HAS_OVAL,
        IS_VULNERABLE;


        public String toParameterName() {
            switch (this) {
                case HAS_CERT_ALERTS: {
                    return "hasCertAlerts";
                }
                case HAS_CERT_NOTES: {
                    return "hasCertNotes";
                }
                case HAS_KEV: {
                    return "hasKev";
                }
                case HAS_OVAL: {
                    return "hasOval";
                }
                case IS_VULNERABLE: {
                    return "isVulnerable";
                }
            }
            return "unknown";
        }
    }

    public static enum Filter {
        CPE_NAME,
        CVE_ID,
        CVSS_V2_METRICS,
        CVSS_V3_METRICS,
        CWE_ID,
        KEYWORD_EXACT_MATCH,
        KEYWORD_SEARCH;


        public String toParameterName() {
            switch (this) {
                case CPE_NAME: {
                    return "cpeName";
                }
                case CVE_ID: {
                    return "cveId";
                }
                case CVSS_V2_METRICS: {
                    return "cvssV2Metrics";
                }
                case CVSS_V3_METRICS: {
                    return "cvssV3Metrics";
                }
                case CWE_ID: {
                    return "cweId";
                }
                case KEYWORD_EXACT_MATCH: {
                    return "keywordExactMatch";
                }
                case KEYWORD_SEARCH: {
                    return "keywordSearch";
                }
            }
            return "unknown";
        }
    }
}

