/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.nvdlib.nvd;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.jeremylong.nvdlib.nvd.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"operator", "negate", "nodes"})
public class Config {
    @JsonProperty(value="operator")
    private Operator operator;
    @JsonProperty(value="negate")
    private Boolean negate;
    @JsonProperty(value="nodes")
    private List<Node> nodes = new ArrayList<Node>();

    @JsonProperty(value="operator")
    public Operator getOperator() {
        return this.operator;
    }

    @JsonProperty(value="negate")
    public Boolean getNegate() {
        return this.negate;
    }

    @JsonProperty(value="nodes")
    public List<Node> getNodes() {
        return this.nodes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Config.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("operator");
        sb.append('=');
        sb.append(this.operator == null ? "<null>" : this.operator);
        sb.append(',');
        sb.append("negate");
        sb.append('=');
        sb.append(this.negate == null ? "<null>" : this.negate);
        sb.append(',');
        sb.append("nodes");
        sb.append('=');
        sb.append(this.nodes == null ? "<null>" : this.nodes);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.nodes == null ? 0 : this.nodes.hashCode());
        result = result * 31 + (this.operator == null ? 0 : this.operator.hashCode());
        result = result * 31 + (this.negate == null ? 0 : this.negate.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Config)) {
            return false;
        }
        Config rhs = (Config)other;
        return (this.nodes == rhs.nodes || this.nodes != null && this.nodes.equals(rhs.nodes)) && (this.operator == rhs.operator || this.operator != null && this.operator.equals((Object)rhs.operator)) && (this.negate == rhs.negate || this.negate != null && this.negate.equals(rhs.negate));
    }

    public static enum Operator {
        AND("AND"),
        OR("OR");

        private final String value;
        private static final Map<String, Operator> CONSTANTS;

        private Operator(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Operator fromValue(String value) {
            Operator constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Operator>();
            for (Operator c : Operator.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

