/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.nvdlib.nvd;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.github.jeremylong.nvdlib.nvd.Config;
import io.github.jeremylong.nvdlib.nvd.LangString;
import io.github.jeremylong.nvdlib.nvd.Metrics;
import io.github.jeremylong.nvdlib.nvd.Reference;
import io.github.jeremylong.nvdlib.nvd.VendorComment;
import io.github.jeremylong.nvdlib.nvd.Weakness;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "sourceIdentifier", "vulnStatus", "published", "lastModified", "evaluatorComment", "evaluatorSolution", "evaluatorImpact", "cisaExploitAdd", "cisaActionDue", "cisaRequiredAction", "cisaVulnerabilityName", "descriptions", "references", "metrics", "weaknesses", "configurations", "vendorComments"})
public class CveItem {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="sourceIdentifier")
    private String sourceIdentifier;
    @JsonProperty(value="vulnStatus")
    private String vulnStatus;
    @JsonProperty(value="published")
    private LocalDateTime published;
    @JsonProperty(value="lastModified")
    private LocalDateTime lastModified;
    @JsonProperty(value="evaluatorComment")
    private String evaluatorComment;
    @JsonProperty(value="evaluatorSolution")
    private String evaluatorSolution;
    @JsonProperty(value="evaluatorImpact")
    private String evaluatorImpact;
    @JsonProperty(value="cisaExploitAdd")
    private LocalDate cisaExploitAdd;
    @JsonProperty(value="cisaActionDue")
    private LocalDate cisaActionDue;
    @JsonProperty(value="cisaRequiredAction")
    private String cisaRequiredAction;
    @JsonProperty(value="cisaVulnerabilityName")
    private String cisaVulnerabilityName;
    @JsonProperty(value="descriptions")
    private List<LangString> descriptions = new ArrayList<LangString>();
    @JsonProperty(value="references")
    private List<Reference> references = new ArrayList<Reference>();
    @JsonProperty(value="metrics")
    @JsonPropertyDescription(value="Metric scores for a vulnerability as found on NVD.")
    private Metrics metrics;
    @JsonProperty(value="weaknesses")
    private List<Weakness> weaknesses = new ArrayList<Weakness>();
    @JsonProperty(value="configurations")
    private List<Config> configurations = new ArrayList<Config>();
    @JsonProperty(value="vendorComments")
    private List<VendorComment> vendorComments = new ArrayList<VendorComment>();

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="sourceIdentifier")
    public String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    @JsonProperty(value="vulnStatus")
    public String getVulnStatus() {
        return this.vulnStatus;
    }

    @JsonProperty(value="published")
    public LocalDateTime getPublished() {
        return this.published;
    }

    @JsonProperty(value="lastModified")
    public LocalDateTime getLastModified() {
        return this.lastModified;
    }

    @JsonProperty(value="evaluatorComment")
    public String getEvaluatorComment() {
        return this.evaluatorComment;
    }

    @JsonProperty(value="evaluatorSolution")
    public String getEvaluatorSolution() {
        return this.evaluatorSolution;
    }

    @JsonProperty(value="evaluatorImpact")
    public String getEvaluatorImpact() {
        return this.evaluatorImpact;
    }

    @JsonProperty(value="cisaExploitAdd")
    public LocalDate getCisaExploitAdd() {
        return this.cisaExploitAdd;
    }

    @JsonProperty(value="cisaActionDue")
    public LocalDate getCisaActionDue() {
        return this.cisaActionDue;
    }

    @JsonProperty(value="cisaRequiredAction")
    public String getCisaRequiredAction() {
        return this.cisaRequiredAction;
    }

    @JsonProperty(value="cisaVulnerabilityName")
    public String getCisaVulnerabilityName() {
        return this.cisaVulnerabilityName;
    }

    @JsonProperty(value="descriptions")
    public List<LangString> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="references")
    public List<Reference> getReferences() {
        return this.references;
    }

    @JsonProperty(value="metrics")
    public Metrics getMetrics() {
        return this.metrics;
    }

    @JsonProperty(value="weaknesses")
    public List<Weakness> getWeaknesses() {
        return this.weaknesses;
    }

    @JsonProperty(value="configurations")
    public List<Config> getConfigurations() {
        return this.configurations;
    }

    @JsonProperty(value="vendorComments")
    public List<VendorComment> getVendorComments() {
        return this.vendorComments;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CveItem.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("sourceIdentifier");
        sb.append('=');
        sb.append(this.sourceIdentifier == null ? "<null>" : this.sourceIdentifier);
        sb.append(',');
        sb.append("vulnStatus");
        sb.append('=');
        sb.append(this.vulnStatus == null ? "<null>" : this.vulnStatus);
        sb.append(',');
        sb.append("published");
        sb.append('=');
        sb.append(this.published == null ? "<null>" : this.published);
        sb.append(',');
        sb.append("lastModified");
        sb.append('=');
        sb.append(this.lastModified == null ? "<null>" : this.lastModified);
        sb.append(',');
        sb.append("evaluatorComment");
        sb.append('=');
        sb.append(this.evaluatorComment == null ? "<null>" : this.evaluatorComment);
        sb.append(',');
        sb.append("evaluatorSolution");
        sb.append('=');
        sb.append(this.evaluatorSolution == null ? "<null>" : this.evaluatorSolution);
        sb.append(',');
        sb.append("evaluatorImpact");
        sb.append('=');
        sb.append(this.evaluatorImpact == null ? "<null>" : this.evaluatorImpact);
        sb.append(',');
        sb.append("cisaExploitAdd");
        sb.append('=');
        sb.append(this.cisaExploitAdd == null ? "<null>" : this.cisaExploitAdd);
        sb.append(',');
        sb.append("cisaActionDue");
        sb.append('=');
        sb.append(this.cisaActionDue == null ? "<null>" : this.cisaActionDue);
        sb.append(',');
        sb.append("cisaRequiredAction");
        sb.append('=');
        sb.append(this.cisaRequiredAction == null ? "<null>" : this.cisaRequiredAction);
        sb.append(',');
        sb.append("cisaVulnerabilityName");
        sb.append('=');
        sb.append(this.cisaVulnerabilityName == null ? "<null>" : this.cisaVulnerabilityName);
        sb.append(',');
        sb.append("descriptions");
        sb.append('=');
        sb.append(this.descriptions == null ? "<null>" : this.descriptions);
        sb.append(',');
        sb.append("references");
        sb.append('=');
        sb.append(this.references == null ? "<null>" : this.references);
        sb.append(',');
        sb.append("metrics");
        sb.append('=');
        sb.append(this.metrics == null ? "<null>" : this.metrics);
        sb.append(',');
        sb.append("weaknesses");
        sb.append('=');
        sb.append(this.weaknesses == null ? "<null>" : this.weaknesses);
        sb.append(',');
        sb.append("configurations");
        sb.append('=');
        sb.append(this.configurations == null ? "<null>" : this.configurations);
        sb.append(',');
        sb.append("vendorComments");
        sb.append('=');
        sb.append(this.vendorComments == null ? "<null>" : this.vendorComments);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.sourceIdentifier == null ? 0 : this.sourceIdentifier.hashCode());
        result = result * 31 + (this.references == null ? 0 : this.references.hashCode());
        result = result * 31 + (this.configurations == null ? 0 : this.configurations.hashCode());
        result = result * 31 + (this.vendorComments == null ? 0 : this.vendorComments.hashCode());
        result = result * 31 + (this.evaluatorSolution == null ? 0 : this.evaluatorSolution.hashCode());
        result = result * 31 + (this.cisaExploitAdd == null ? 0 : this.cisaExploitAdd.hashCode());
        result = result * 31 + (this.published == null ? 0 : this.published.hashCode());
        result = result * 31 + (this.vulnStatus == null ? 0 : this.vulnStatus.hashCode());
        result = result * 31 + (this.descriptions == null ? 0 : this.descriptions.hashCode());
        result = result * 31 + (this.cisaActionDue == null ? 0 : this.cisaActionDue.hashCode());
        result = result * 31 + (this.cisaVulnerabilityName == null ? 0 : this.cisaVulnerabilityName.hashCode());
        result = result * 31 + (this.cisaRequiredAction == null ? 0 : this.cisaRequiredAction.hashCode());
        result = result * 31 + (this.weaknesses == null ? 0 : this.weaknesses.hashCode());
        result = result * 31 + (this.evaluatorImpact == null ? 0 : this.evaluatorImpact.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.lastModified == null ? 0 : this.lastModified.hashCode());
        result = result * 31 + (this.metrics == null ? 0 : this.metrics.hashCode());
        result = result * 31 + (this.evaluatorComment == null ? 0 : this.evaluatorComment.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CveItem)) {
            return false;
        }
        CveItem rhs = (CveItem)other;
        return (this.sourceIdentifier == rhs.sourceIdentifier || this.sourceIdentifier != null && this.sourceIdentifier.equals(rhs.sourceIdentifier)) && (this.references == rhs.references || this.references != null && this.references.equals(rhs.references)) && (this.configurations == rhs.configurations || this.configurations != null && this.configurations.equals(rhs.configurations)) && (this.vendorComments == rhs.vendorComments || this.vendorComments != null && this.vendorComments.equals(rhs.vendorComments)) && (this.evaluatorSolution == rhs.evaluatorSolution || this.evaluatorSolution != null && this.evaluatorSolution.equals(rhs.evaluatorSolution)) && (this.cisaExploitAdd == rhs.cisaExploitAdd || this.cisaExploitAdd != null && this.cisaExploitAdd.equals(rhs.cisaExploitAdd)) && (this.published == rhs.published || this.published != null && this.published.equals(rhs.published)) && (this.vulnStatus == rhs.vulnStatus || this.vulnStatus != null && this.vulnStatus.equals(rhs.vulnStatus)) && (this.descriptions == rhs.descriptions || this.descriptions != null && this.descriptions.equals(rhs.descriptions)) && (this.cisaActionDue == rhs.cisaActionDue || this.cisaActionDue != null && this.cisaActionDue.equals(rhs.cisaActionDue)) && (this.cisaVulnerabilityName == rhs.cisaVulnerabilityName || this.cisaVulnerabilityName != null && this.cisaVulnerabilityName.equals(rhs.cisaVulnerabilityName)) && (this.cisaRequiredAction == rhs.cisaRequiredAction || this.cisaRequiredAction != null && this.cisaRequiredAction.equals(rhs.cisaRequiredAction)) && (this.weaknesses == rhs.weaknesses || this.weaknesses != null && this.weaknesses.equals(rhs.weaknesses)) && (this.evaluatorImpact == rhs.evaluatorImpact || this.evaluatorImpact != null && this.evaluatorImpact.equals(rhs.evaluatorImpact)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.lastModified == rhs.lastModified || this.lastModified != null && this.lastModified.equals(rhs.lastModified)) && (this.metrics == rhs.metrics || this.metrics != null && this.metrics.equals(rhs.metrics)) && (this.evaluatorComment == rhs.evaluatorComment || this.evaluatorComment != null && this.evaluatorComment.equals(rhs.evaluatorComment));
    }
}

