/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.nvdlib.nvd;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.jeremylong.nvdlib.nvd.CvssV30__1;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"source", "type", "cvssData", "exploitabilityScore", "impactScore"})
public class CvssV30 {
    @JsonProperty(value="source")
    private String source;
    @JsonProperty(value="type")
    private Type type;
    @JsonProperty(value="cvssData")
    private CvssV30__1 cvssData;
    @JsonProperty(value="exploitabilityScore")
    @JsonPropertyDescription(value="CVSS subscore.")
    private Double exploitabilityScore;
    @JsonProperty(value="impactScore")
    @JsonPropertyDescription(value="CVSS subscore.")
    private Double impactScore;

    @JsonProperty(value="source")
    public String getSource() {
        return this.source;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="cvssData")
    public CvssV30__1 getCvssData() {
        return this.cvssData;
    }

    @JsonProperty(value="exploitabilityScore")
    public Double getExploitabilityScore() {
        return this.exploitabilityScore;
    }

    @JsonProperty(value="impactScore")
    public Double getImpactScore() {
        return this.impactScore;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CvssV30.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("source");
        sb.append('=');
        sb.append(this.source == null ? "<null>" : this.source);
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("cvssData");
        sb.append('=');
        sb.append(this.cvssData == null ? "<null>" : this.cvssData);
        sb.append(',');
        sb.append("exploitabilityScore");
        sb.append('=');
        sb.append(this.exploitabilityScore == null ? "<null>" : this.exploitabilityScore);
        sb.append(',');
        sb.append("impactScore");
        sb.append('=');
        sb.append(this.impactScore == null ? "<null>" : this.impactScore);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.cvssData == null ? 0 : this.cvssData.hashCode());
        result = result * 31 + (this.exploitabilityScore == null ? 0 : this.exploitabilityScore.hashCode());
        result = result * 31 + (this.source == null ? 0 : this.source.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.impactScore == null ? 0 : this.impactScore.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CvssV30)) {
            return false;
        }
        CvssV30 rhs = (CvssV30)other;
        return (this.cvssData == rhs.cvssData || this.cvssData != null && this.cvssData.equals(rhs.cvssData)) && (this.exploitabilityScore == rhs.exploitabilityScore || this.exploitabilityScore != null && this.exploitabilityScore.equals(rhs.exploitabilityScore)) && (this.source == rhs.source || this.source != null && this.source.equals(rhs.source)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.impactScore == rhs.impactScore || this.impactScore != null && this.impactScore.equals(rhs.impactScore));
    }

    public static enum Type {
        PRIMARY("Primary"),
        SECONDARY("Secondary");

        private final String value;
        private static final Map<String, Type> CONSTANTS;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

