/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.nvdlib;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.github.jeremylong.nvdlib.NvdApiException;
import io.github.jeremylong.nvdlib.RateLimitedClient;
import io.github.jeremylong.nvdlib.RateMeter;
import io.github.jeremylong.nvdlib.nvd.CveApiJson20;
import io.github.jeremylong.nvdlib.nvd.DefCveItem;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.net.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NvdCveApi
implements AutoCloseable,
Iterator<Collection<DefCveItem>> {
    private static final Logger LOG = LoggerFactory.getLogger(NvdCveApi.class);
    private static final String DEFAULT_ENDPOINT = "https://services.nvd.nist.gov/rest/json/cves/2.0";
    private static final String API_KEY_NAME = "apiKey";
    private final String apiKey;
    private final String endpoint;
    private final ObjectMapper objectMapper;
    private RateMeter meter;
    private List<RateLimitedClient> clients;
    private List<Future<SimpleHttpResponse>> futures = new ArrayList<Future<SimpleHttpResponse>>();
    private boolean firstCall = true;
    private int resultsPerPage = 2000;
    private int totalResults = -1;
    private long lastModifiedRequest = 0L;
    private int maxPageCount;
    private List<NameValuePair> filters;
    private int lastStatusCode = 200;

    NvdCveApi(String apiKey, String endpoint, int threadCount, int maxPageCount) {
        this(apiKey, endpoint, apiKey == null ? 6500L : 600L, threadCount, maxPageCount);
    }

    NvdCveApi(String apiKey, String endpoint, long delay, int threadCount, int maxPageCount) {
        this.apiKey = apiKey;
        this.endpoint = endpoint == null ? DEFAULT_ENDPOINT : endpoint;
        if (threadCount <= 0) {
            threadCount = 1;
        }
        this.maxPageCount = maxPageCount;
        if (apiKey == null) {
            if (threadCount > 1) {
                LOG.warn("No api key provided; as such the thread count has been reset to 1 instead of the requestsed {}", (Object)threadCount);
                threadCount = 1;
            }
            this.meter = new RateMeter(5, 32500L);
        } else {
            this.meter = new RateMeter(50, 32500L);
        }
        this.clients = new ArrayList<RateLimitedClient>(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            this.clients.add(new RateLimitedClient(delay, this.meter));
        }
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule((Module)new JavaTimeModule());
    }

    public long getLastModifiedRequest() {
        return this.lastModifiedRequest;
    }

    void setFilters(List<NameValuePair> filters) {
        this.filters = filters;
    }

    void setResultsPerPage(int resultsPerPage) {
        this.resultsPerPage = resultsPerPage;
    }

    public int getLastStatusCode() {
        return this.lastStatusCode;
    }

    private Future<SimpleHttpResponse> callApi(int clientIndex, int startIndex) throws NvdApiException {
        try {
            URIBuilder uriBuilder = new URIBuilder(this.endpoint);
            if (this.filters != null) {
                uriBuilder.addParameters(this.filters);
            }
            uriBuilder.addParameter("resultsPerPage", Integer.toString(this.resultsPerPage));
            uriBuilder.addParameter("startIndex", Integer.toString(startIndex));
            SimpleRequestBuilder builder = SimpleRequestBuilder.get();
            if (this.apiKey != null) {
                builder.addHeader(API_KEY_NAME, this.apiKey);
            }
            builder.addHeader("User-Agent", "vulnz");
            URI uri = uriBuilder.build();
            LOG.debug("requesting URI: {}", (Object)uri.toString());
            SimpleHttpRequest request = builder.setUri(uri).build();
            return this.clients.get(clientIndex).execute(request);
        }
        catch (URISyntaxException e) {
            throw new NvdApiException(e);
        }
    }

    @Override
    public void close() throws Exception {
        for (RateLimitedClient rateLimitedClient : this.clients) {
            rateLimitedClient.close();
        }
        this.clients = null;
        if (this.futures.size() > 0) {
            for (Future future : this.futures) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
            this.futures.clear();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.lastStatusCode != 200) {
            return false;
        }
        return this.firstCall || !this.futures.isEmpty();
    }

    @Override
    public Collection<DefCveItem> next() {
        if (this.firstCall) {
            this.futures.add(this.callApi(0, 0));
        }
        String json = "";
        try {
            SimpleHttpResponse response = this.getCompletedFuture();
            if (response.getCode() == 200) {
                LOG.debug("Conent-Type Received: {}", (Object)response.getContentType());
                json = response.getBodyText();
                if (json == null && response.getBody().isBytes()) {
                    json = new String(response.getBodyBytes(), StandardCharsets.UTF_8);
                }
                CveApiJson20 current = (CveApiJson20)this.objectMapper.readValue(json, CveApiJson20.class);
                this.totalResults = current.getTotalResults();
                long lastModified = current.getTimestamp().toEpochSecond();
                if (lastModified > this.lastModifiedRequest) {
                    this.lastModifiedRequest = lastModified;
                }
                if (this.firstCall) {
                    this.firstCall = false;
                    this.queueCalls();
                }
                return current.getVulnerabilities();
            }
            this.lastStatusCode = response.getCode();
            LOG.debug("Status Code: {}", (Object)this.lastStatusCode);
            LOG.debug("Response: {}", (Object)response.getBodyText());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new NvdApiException(e);
        }
        catch (ExecutionException e) {
            throw new NvdApiException(e);
        }
        catch (JsonProcessingException e) {
            throw new NvdApiException(e);
        }
        return null;
    }

    private SimpleHttpResponse getCompletedFuture() throws InterruptedException, ExecutionException {
        boolean notFound = this.futures.size() > 0;
        Future<SimpleHttpResponse> result = null;
        while (notFound) {
            for (Future<SimpleHttpResponse> future : this.futures) {
                if (!future.isDone()) continue;
                result = future;
                notFound = false;
                break;
            }
            Thread.sleep(500L);
        }
        if (result != null) {
            this.futures.remove(result);
            return (SimpleHttpResponse)result.get();
        }
        return null;
    }

    private void queueCalls() {
        int clientIndex = 0;
        int pageCount = 1;
        for (int i = this.resultsPerPage; (this.maxPageCount <= 0 || pageCount < this.maxPageCount) && i < this.totalResults; i += this.resultsPerPage) {
            this.futures.add(this.callApi(clientIndex, i));
            ++pageCount;
            if (++clientIndex < this.clients.size()) continue;
            clientIndex = 0;
        }
    }
}

