/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.nvdlib;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateMeter {
    private static final Logger LOG = LoggerFactory.getLogger(RateMeter.class);
    private final BlockingQueue<Ticket> queue = new DelayQueue<Ticket>();
    private int quantity;
    private long durationMilliseconds;

    public RateMeter(int quantity, long durationMilliseconds) {
        this.quantity = quantity;
        this.durationMilliseconds = durationMilliseconds;
    }

    public synchronized Ticket getTicket() throws InterruptedException {
        if (this.queue.size() >= this.quantity) {
            Ticket ticket = this.queue.take();
            if (LOG.isDebugEnabled()) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
                LocalTime time = LocalTime.now();
                LOG.debug("Ticket taken At: {}; count: {}", (Object)time.format(formatter), (Object)(this.queue.size() + 1));
            }
            return ticket;
        }
        if (LOG.isDebugEnabled()) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
            LocalTime time = LocalTime.now();
            LOG.debug("Ticket taken At: {}; count: {}", (Object)time.format(formatter), (Object)(this.queue.size() + 1));
        }
        return new Ticket(this);
    }

    synchronized void replaceTicket() throws InterruptedException {
        if (this.queue.size() < this.quantity) {
            if (LOG.isDebugEnabled()) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
                LocalTime time = LocalTime.now();
                LOG.debug("Ticket returned At: {}; count: {}", (Object)time.format(formatter), (Object)(this.queue.size() + 1));
            }
            this.queue.put(new Ticket(this));
        }
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public long getDurationMilliseconds() {
        return this.durationMilliseconds;
    }

    public void setDurationMilliseconds(long durationMilliseconds) {
        this.durationMilliseconds = durationMilliseconds;
    }

    public static class Ticket
    implements Delayed,
    AutoCloseable {
        private final RateMeter meter;
        private final long startTime;

        Ticket(RateMeter meter) {
            this.meter = meter;
            this.startTime = System.currentTimeMillis() + meter.getDurationMilliseconds();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long diff = this.startTime - System.currentTimeMillis();
            return unit.convert(diff, TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            return (int)(this.startTime - ((Ticket)o).startTime);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Ticket ticket = (Ticket)o;
            return this.startTime == ticket.startTime;
        }

        public int hashCode() {
            return Objects.hash(this.startTime);
        }

        @Override
        public void close() throws Exception {
            this.meter.replaceTicket();
        }
    }
}

