/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.nvdlib.nvd;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.jeremylong.nvdlib.nvd.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"operator", "negate", "nodes"})
public class Config {
    @JsonProperty(value="operator")
    private Operator operator;
    @JsonProperty(value="negate")
    private Boolean negate;
    @JsonProperty(value="nodes")
    private List<Node> nodes = new ArrayList<Node>();

    @JsonProperty(value="operator")
    public Operator getOperator() {
        return this.operator;
    }

    @JsonProperty(value="negate")
    public Boolean getNegate() {
        return this.negate;
    }

    @JsonProperty(value="nodes")
    public List<Node> getNodes() {
        return this.nodes;
    }

    public String toString() {
        return "Config{operator=" + (Object)((Object)this.operator) + ", negate=" + this.negate + ", nodes=" + this.nodes + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config config = (Config)o;
        return this.operator == config.operator && Objects.equals(this.negate, config.negate) && Objects.equals(this.nodes, config.nodes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.negate, this.nodes});
    }

    public static enum Operator {
        AND("AND"),
        OR("OR");

        private static final Map<String, Operator> CONSTANTS;
        private final String value;

        private Operator(String value) {
            this.value = value;
        }

        @JsonCreator
        public static Operator fromValue(String value) {
            Operator constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, Operator>();
            for (Operator c : Operator.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

