/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.nvdlib.nvd;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.github.jeremylong.nvdlib.nvd.Config;
import io.github.jeremylong.nvdlib.nvd.LangString;
import io.github.jeremylong.nvdlib.nvd.Metrics;
import io.github.jeremylong.nvdlib.nvd.Reference;
import io.github.jeremylong.nvdlib.nvd.VendorComment;
import io.github.jeremylong.nvdlib.nvd.Weakness;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "sourceIdentifier", "vulnStatus", "published", "lastModified", "evaluatorComment", "evaluatorSolution", "evaluatorImpact", "cisaExploitAdd", "cisaActionDue", "cisaRequiredAction", "cisaVulnerabilityName", "descriptions", "references", "metrics", "weaknesses", "configurations", "vendorComments"})
public class CveItem {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="sourceIdentifier")
    private String sourceIdentifier;
    @JsonProperty(value="vulnStatus")
    private String vulnStatus;
    @JsonProperty(value="published")
    @JsonFormat(pattern="uuuu-MM-dd'T'HH:mm:ss.SSS", timezone="UTC")
    private ZonedDateTime published;
    @JsonProperty(value="lastModified")
    @JsonFormat(pattern="uuuu-MM-dd'T'HH:mm:ss.SSS", timezone="UTC")
    private ZonedDateTime lastModified;
    @JsonProperty(value="evaluatorComment")
    private String evaluatorComment;
    @JsonProperty(value="evaluatorSolution")
    private String evaluatorSolution;
    @JsonProperty(value="evaluatorImpact")
    private String evaluatorImpact;
    @JsonProperty(value="cisaExploitAdd")
    private LocalDate cisaExploitAdd;
    @JsonProperty(value="cisaActionDue")
    private LocalDate cisaActionDue;
    @JsonProperty(value="cisaRequiredAction")
    private String cisaRequiredAction;
    @JsonProperty(value="cisaVulnerabilityName")
    private String cisaVulnerabilityName;
    @JsonProperty(value="descriptions")
    private List<LangString> descriptions = new ArrayList<LangString>();
    @JsonProperty(value="references")
    private List<Reference> references = new ArrayList<Reference>();
    @JsonProperty(value="metrics")
    @JsonPropertyDescription(value="Metric scores for a vulnerability as found on NVD.")
    private Metrics metrics;
    @JsonProperty(value="weaknesses")
    private List<Weakness> weaknesses = new ArrayList<Weakness>();
    @JsonProperty(value="configurations")
    private List<Config> configurations = new ArrayList<Config>();
    @JsonProperty(value="vendorComments")
    private List<VendorComment> vendorComments = new ArrayList<VendorComment>();

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="sourceIdentifier")
    public String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    @JsonProperty(value="vulnStatus")
    public String getVulnStatus() {
        return this.vulnStatus;
    }

    @JsonProperty(value="published")
    public ZonedDateTime getPublished() {
        return this.published;
    }

    @JsonProperty(value="lastModified")
    public ZonedDateTime getLastModified() {
        return this.lastModified;
    }

    @JsonProperty(value="evaluatorComment")
    public String getEvaluatorComment() {
        return this.evaluatorComment;
    }

    @JsonProperty(value="evaluatorSolution")
    public String getEvaluatorSolution() {
        return this.evaluatorSolution;
    }

    @JsonProperty(value="evaluatorImpact")
    public String getEvaluatorImpact() {
        return this.evaluatorImpact;
    }

    @JsonProperty(value="cisaExploitAdd")
    public LocalDate getCisaExploitAdd() {
        return this.cisaExploitAdd;
    }

    @JsonProperty(value="cisaActionDue")
    public LocalDate getCisaActionDue() {
        return this.cisaActionDue;
    }

    @JsonProperty(value="cisaRequiredAction")
    public String getCisaRequiredAction() {
        return this.cisaRequiredAction;
    }

    @JsonProperty(value="cisaVulnerabilityName")
    public String getCisaVulnerabilityName() {
        return this.cisaVulnerabilityName;
    }

    @JsonProperty(value="descriptions")
    public List<LangString> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="references")
    public List<Reference> getReferences() {
        return this.references;
    }

    @JsonProperty(value="metrics")
    public Metrics getMetrics() {
        return this.metrics;
    }

    @JsonProperty(value="weaknesses")
    public List<Weakness> getWeaknesses() {
        return this.weaknesses;
    }

    @JsonProperty(value="configurations")
    public List<Config> getConfigurations() {
        return this.configurations;
    }

    @JsonProperty(value="vendorComments")
    public List<VendorComment> getVendorComments() {
        return this.vendorComments;
    }

    public String toString() {
        return "CveItem{id='" + this.id + '\'' + ", sourceIdentifier='" + this.sourceIdentifier + '\'' + ", vulnStatus='" + this.vulnStatus + '\'' + ", published=" + this.published + ", lastModified=" + this.lastModified + ", evaluatorComment='" + this.evaluatorComment + '\'' + ", evaluatorSolution='" + this.evaluatorSolution + '\'' + ", evaluatorImpact='" + this.evaluatorImpact + '\'' + ", cisaExploitAdd=" + this.cisaExploitAdd + ", cisaActionDue=" + this.cisaActionDue + ", cisaRequiredAction='" + this.cisaRequiredAction + '\'' + ", cisaVulnerabilityName='" + this.cisaVulnerabilityName + '\'' + ", descriptions=" + this.descriptions + ", references=" + this.references + ", metrics=" + this.metrics + ", weaknesses=" + this.weaknesses + ", configurations=" + this.configurations + ", vendorComments=" + this.vendorComments + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CveItem cveItem = (CveItem)o;
        return Objects.equals(this.id, cveItem.id) && Objects.equals(this.sourceIdentifier, cveItem.sourceIdentifier) && Objects.equals(this.vulnStatus, cveItem.vulnStatus) && Objects.equals(this.published, cveItem.published) && Objects.equals(this.lastModified, cveItem.lastModified) && Objects.equals(this.evaluatorComment, cveItem.evaluatorComment) && Objects.equals(this.evaluatorSolution, cveItem.evaluatorSolution) && Objects.equals(this.evaluatorImpact, cveItem.evaluatorImpact) && Objects.equals(this.cisaExploitAdd, cveItem.cisaExploitAdd) && Objects.equals(this.cisaActionDue, cveItem.cisaActionDue) && Objects.equals(this.cisaRequiredAction, cveItem.cisaRequiredAction) && Objects.equals(this.cisaVulnerabilityName, cveItem.cisaVulnerabilityName) && Objects.equals(this.descriptions, cveItem.descriptions) && Objects.equals(this.references, cveItem.references) && Objects.equals(this.metrics, cveItem.metrics) && Objects.equals(this.weaknesses, cveItem.weaknesses) && Objects.equals(this.configurations, cveItem.configurations) && Objects.equals(this.vendorComments, cveItem.vendorComments);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.sourceIdentifier, this.vulnStatus, this.published, this.lastModified, this.evaluatorComment, this.evaluatorSolution, this.evaluatorImpact, this.cisaExploitAdd, this.cisaActionDue, this.cisaRequiredAction, this.cisaVulnerabilityName, this.descriptions, this.references, this.metrics, this.weaknesses, this.configurations, this.vendorComments);
    }
}

