/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.nvdlib.nvd;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.jeremylong.nvdlib.nvd.CvssV20;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"source", "type", "cvssData", "baseSeverity", "exploitabilityScore", "impactScore", "acInsufInfo", "obtainAllPrivilege", "obtainUserPrivilege", "obtainOtherPrivilege", "userInteractionRequired"})
public class CvssV2 {
    @JsonProperty(value="source")
    private String source;
    @JsonProperty(value="type")
    private Type type;
    @JsonProperty(value="cvssData")
    private CvssV20 cvssData;
    @JsonProperty(value="baseSeverity")
    private String baseSeverity;
    @JsonProperty(value="exploitabilityScore")
    @JsonPropertyDescription(value="CVSS subscore.")
    private Double exploitabilityScore;
    @JsonProperty(value="impactScore")
    @JsonPropertyDescription(value="CVSS subscore.")
    private Double impactScore;
    @JsonProperty(value="acInsufInfo")
    private Boolean acInsufInfo;
    @JsonProperty(value="obtainAllPrivilege")
    private Boolean obtainAllPrivilege;
    @JsonProperty(value="obtainUserPrivilege")
    private Boolean obtainUserPrivilege;
    @JsonProperty(value="obtainOtherPrivilege")
    private Boolean obtainOtherPrivilege;
    @JsonProperty(value="userInteractionRequired")
    private Boolean userInteractionRequired;

    @JsonProperty(value="source")
    public String getSource() {
        return this.source;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="cvssData")
    public CvssV20 getCvssData() {
        return this.cvssData;
    }

    @JsonProperty(value="baseSeverity")
    public String getBaseSeverity() {
        return this.baseSeverity;
    }

    @JsonProperty(value="exploitabilityScore")
    public Double getExploitabilityScore() {
        return this.exploitabilityScore;
    }

    @JsonProperty(value="impactScore")
    public Double getImpactScore() {
        return this.impactScore;
    }

    @JsonProperty(value="acInsufInfo")
    public Boolean getAcInsufInfo() {
        return this.acInsufInfo;
    }

    @JsonProperty(value="obtainAllPrivilege")
    public Boolean getObtainAllPrivilege() {
        return this.obtainAllPrivilege;
    }

    @JsonProperty(value="obtainUserPrivilege")
    public Boolean getObtainUserPrivilege() {
        return this.obtainUserPrivilege;
    }

    @JsonProperty(value="obtainOtherPrivilege")
    public Boolean getObtainOtherPrivilege() {
        return this.obtainOtherPrivilege;
    }

    @JsonProperty(value="userInteractionRequired")
    public Boolean getUserInteractionRequired() {
        return this.userInteractionRequired;
    }

    public String toString() {
        return "CvssV2{source='" + this.source + '\'' + ", type=" + (Object)((Object)this.type) + ", cvssData=" + this.cvssData + ", baseSeverity='" + this.baseSeverity + '\'' + ", exploitabilityScore=" + this.exploitabilityScore + ", impactScore=" + this.impactScore + ", acInsufInfo=" + this.acInsufInfo + ", obtainAllPrivilege=" + this.obtainAllPrivilege + ", obtainUserPrivilege=" + this.obtainUserPrivilege + ", obtainOtherPrivilege=" + this.obtainOtherPrivilege + ", userInteractionRequired=" + this.userInteractionRequired + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CvssV2 cvssV2 = (CvssV2)o;
        return Objects.equals(this.source, cvssV2.source) && this.type == cvssV2.type && Objects.equals(this.cvssData, cvssV2.cvssData) && Objects.equals(this.baseSeverity, cvssV2.baseSeverity) && Objects.equals(this.exploitabilityScore, cvssV2.exploitabilityScore) && Objects.equals(this.impactScore, cvssV2.impactScore) && Objects.equals(this.acInsufInfo, cvssV2.acInsufInfo) && Objects.equals(this.obtainAllPrivilege, cvssV2.obtainAllPrivilege) && Objects.equals(this.obtainUserPrivilege, cvssV2.obtainUserPrivilege) && Objects.equals(this.obtainOtherPrivilege, cvssV2.obtainOtherPrivilege) && Objects.equals(this.userInteractionRequired, cvssV2.userInteractionRequired);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.source, this.type, this.cvssData, this.baseSeverity, this.exploitabilityScore, this.impactScore, this.acInsufInfo, this.obtainAllPrivilege, this.obtainUserPrivilege, this.obtainOtherPrivilege, this.userInteractionRequired});
    }

    public static enum Type {
        PRIMARY("Primary"),
        SECONDARY("Secondary");

        private static final Map<String, Type> CONSTANTS;
        private final String value;

        private Type(String value) {
            this.value = value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

