/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.nvdlib.nvd;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.jeremylong.nvdlib.nvd.CvssV31Data;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"source", "type", "cvssData", "exploitabilityScore", "impactScore"})
public class CvssV31 {
    @JsonProperty(value="source")
    private String source;
    @JsonProperty(value="type")
    private Type type;
    @JsonProperty(value="cvssData")
    private CvssV31Data cvssData;
    @JsonProperty(value="exploitabilityScore")
    @JsonPropertyDescription(value="CVSS subscore.")
    private Double exploitabilityScore;
    @JsonProperty(value="impactScore")
    @JsonPropertyDescription(value="CVSS subscore.")
    private Double impactScore;

    @JsonProperty(value="source")
    public String getSource() {
        return this.source;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="cvssData")
    public CvssV31Data getCvssData() {
        return this.cvssData;
    }

    @JsonProperty(value="exploitabilityScore")
    public Double getExploitabilityScore() {
        return this.exploitabilityScore;
    }

    @JsonProperty(value="impactScore")
    public Double getImpactScore() {
        return this.impactScore;
    }

    public String toString() {
        return "CvssV31{source='" + this.source + '\'' + ", type=" + (Object)((Object)this.type) + ", cvssData=" + this.cvssData + ", exploitabilityScore=" + this.exploitabilityScore + ", impactScore=" + this.impactScore + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CvssV31 cvssV31 = (CvssV31)o;
        return Objects.equals(this.source, cvssV31.source) && this.type == cvssV31.type && Objects.equals(this.cvssData, cvssV31.cvssData) && Objects.equals(this.exploitabilityScore, cvssV31.exploitabilityScore) && Objects.equals(this.impactScore, cvssV31.impactScore);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.source, this.type, this.cvssData, this.exploitabilityScore, this.impactScore});
    }

    public static enum Type {
        PRIMARY("Primary"),
        SECONDARY("Secondary");

        private static final Map<String, Type> CONSTANTS;
        private final String value;

        private Type(String value) {
            this.value = value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

