/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.nvdlib.nvd;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"version", "vectorString", "attackVector", "attackComplexity", "privilegesRequired", "userInteraction", "scope", "confidentialityImpact", "integrityImpact", "availabilityImpact", "baseScore", "baseSeverity", "exploitCodeMaturity", "remediationLevel", "reportConfidence", "temporalScore", "temporalSeverity", "confidentialityRequirement", "integrityRequirement", "availabilityRequirement", "modifiedAttackVector", "modifiedAttackComplexity", "modifiedPrivilegesRequired", "modifiedUserInteraction", "modifiedScope", "modifiedConfidentialityImpact", "modifiedIntegrityImpact", "modifiedAvailabilityImpact", "environmentalScore", "environmentalSeverity"})
public class CvssV31Data {
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="CVSS Version")
    private Version version;
    @JsonProperty(value="vectorString")
    private String vectorString;
    @JsonProperty(value="attackVector")
    private AttackVectorType attackVector;
    @JsonProperty(value="attackComplexity")
    private AttackComplexityType attackComplexity;
    @JsonProperty(value="privilegesRequired")
    private PrivilegesRequiredType privilegesRequired;
    @JsonProperty(value="userInteraction")
    private UserInteractionType userInteraction;
    @JsonProperty(value="scope")
    private ScopeType scope;
    @JsonProperty(value="confidentialityImpact")
    private CiaType confidentialityImpact;
    @JsonProperty(value="integrityImpact")
    private CiaType integrityImpact;
    @JsonProperty(value="availabilityImpact")
    private CiaType availabilityImpact;
    @JsonProperty(value="baseScore")
    private Double baseScore;
    @JsonProperty(value="baseSeverity")
    private SeverityType baseSeverity;
    @JsonProperty(value="exploitCodeMaturity")
    private ExploitCodeMaturityType exploitCodeMaturity;
    @JsonProperty(value="remediationLevel")
    private RemediationLevelType remediationLevel;
    @JsonProperty(value="reportConfidence")
    private ConfidenceType reportConfidence;
    @JsonProperty(value="temporalScore")
    private Double temporalScore;
    @JsonProperty(value="temporalSeverity")
    private SeverityType temporalSeverity;
    @JsonProperty(value="confidentialityRequirement")
    private CiaRequirementType confidentialityRequirement;
    @JsonProperty(value="integrityRequirement")
    private CiaRequirementType integrityRequirement;
    @JsonProperty(value="availabilityRequirement")
    private CiaRequirementType availabilityRequirement;
    @JsonProperty(value="modifiedAttackVector")
    private ModifiedAttackVectorType modifiedAttackVector;
    @JsonProperty(value="modifiedAttackComplexity")
    private ModifiedAttackComplexityType modifiedAttackComplexity;
    @JsonProperty(value="modifiedPrivilegesRequired")
    private ModifiedPrivilegesRequiredType modifiedPrivilegesRequired;
    @JsonProperty(value="modifiedUserInteraction")
    private ModifiedUserInteractionType modifiedUserInteraction;
    @JsonProperty(value="modifiedScope")
    private ModifiedScopeType modifiedScope;
    @JsonProperty(value="modifiedConfidentialityImpact")
    private ModifiedCiaType modifiedConfidentialityImpact;
    @JsonProperty(value="modifiedIntegrityImpact")
    private ModifiedCiaType modifiedIntegrityImpact;
    @JsonProperty(value="modifiedAvailabilityImpact")
    private ModifiedCiaType modifiedAvailabilityImpact;
    @JsonProperty(value="environmentalScore")
    private Double environmentalScore;
    @JsonProperty(value="environmentalSeverity")
    private SeverityType environmentalSeverity;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonProperty(value="version")
    public Version getVersion() {
        return this.version;
    }

    @JsonProperty(value="vectorString")
    public String getVectorString() {
        return this.vectorString;
    }

    @JsonProperty(value="attackVector")
    public AttackVectorType getAttackVector() {
        return this.attackVector;
    }

    @JsonProperty(value="attackComplexity")
    public AttackComplexityType getAttackComplexity() {
        return this.attackComplexity;
    }

    @JsonProperty(value="privilegesRequired")
    public PrivilegesRequiredType getPrivilegesRequired() {
        return this.privilegesRequired;
    }

    @JsonProperty(value="userInteraction")
    public UserInteractionType getUserInteraction() {
        return this.userInteraction;
    }

    @JsonProperty(value="scope")
    public ScopeType getScope() {
        return this.scope;
    }

    @JsonProperty(value="confidentialityImpact")
    public CiaType getConfidentialityImpact() {
        return this.confidentialityImpact;
    }

    @JsonProperty(value="integrityImpact")
    public CiaType getIntegrityImpact() {
        return this.integrityImpact;
    }

    @JsonProperty(value="availabilityImpact")
    public CiaType getAvailabilityImpact() {
        return this.availabilityImpact;
    }

    @JsonProperty(value="baseScore")
    public Double getBaseScore() {
        return this.baseScore;
    }

    @JsonProperty(value="baseSeverity")
    public SeverityType getBaseSeverity() {
        return this.baseSeverity;
    }

    @JsonProperty(value="exploitCodeMaturity")
    public ExploitCodeMaturityType getExploitCodeMaturity() {
        return this.exploitCodeMaturity;
    }

    @JsonProperty(value="remediationLevel")
    public RemediationLevelType getRemediationLevel() {
        return this.remediationLevel;
    }

    @JsonProperty(value="reportConfidence")
    public ConfidenceType getReportConfidence() {
        return this.reportConfidence;
    }

    @JsonProperty(value="temporalScore")
    public Double getTemporalScore() {
        return this.temporalScore;
    }

    @JsonProperty(value="temporalSeverity")
    public SeverityType getTemporalSeverity() {
        return this.temporalSeverity;
    }

    @JsonProperty(value="confidentialityRequirement")
    public CiaRequirementType getConfidentialityRequirement() {
        return this.confidentialityRequirement;
    }

    @JsonProperty(value="integrityRequirement")
    public CiaRequirementType getIntegrityRequirement() {
        return this.integrityRequirement;
    }

    @JsonProperty(value="availabilityRequirement")
    public CiaRequirementType getAvailabilityRequirement() {
        return this.availabilityRequirement;
    }

    @JsonProperty(value="modifiedAttackVector")
    public ModifiedAttackVectorType getModifiedAttackVector() {
        return this.modifiedAttackVector;
    }

    @JsonProperty(value="modifiedAttackComplexity")
    public ModifiedAttackComplexityType getModifiedAttackComplexity() {
        return this.modifiedAttackComplexity;
    }

    @JsonProperty(value="modifiedPrivilegesRequired")
    public ModifiedPrivilegesRequiredType getModifiedPrivilegesRequired() {
        return this.modifiedPrivilegesRequired;
    }

    @JsonProperty(value="modifiedUserInteraction")
    public ModifiedUserInteractionType getModifiedUserInteraction() {
        return this.modifiedUserInteraction;
    }

    @JsonProperty(value="modifiedScope")
    public ModifiedScopeType getModifiedScope() {
        return this.modifiedScope;
    }

    @JsonProperty(value="modifiedConfidentialityImpact")
    public ModifiedCiaType getModifiedConfidentialityImpact() {
        return this.modifiedConfidentialityImpact;
    }

    @JsonProperty(value="modifiedIntegrityImpact")
    public ModifiedCiaType getModifiedIntegrityImpact() {
        return this.modifiedIntegrityImpact;
    }

    @JsonProperty(value="modifiedAvailabilityImpact")
    public ModifiedCiaType getModifiedAvailabilityImpact() {
        return this.modifiedAvailabilityImpact;
    }

    @JsonProperty(value="environmentalScore")
    public Double getEnvironmentalScore() {
        return this.environmentalScore;
    }

    @JsonProperty(value="environmentalSeverity")
    public SeverityType getEnvironmentalSeverity() {
        return this.environmentalSeverity;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "CvssV31Data{version=" + (Object)((Object)this.version) + ", vectorString='" + this.vectorString + '\'' + ", attackVector=" + (Object)((Object)this.attackVector) + ", attackComplexity=" + (Object)((Object)this.attackComplexity) + ", privilegesRequired=" + (Object)((Object)this.privilegesRequired) + ", userInteraction=" + (Object)((Object)this.userInteraction) + ", scope=" + (Object)((Object)this.scope) + ", confidentialityImpact=" + (Object)((Object)this.confidentialityImpact) + ", integrityImpact=" + (Object)((Object)this.integrityImpact) + ", availabilityImpact=" + (Object)((Object)this.availabilityImpact) + ", baseScore=" + this.baseScore + ", baseSeverity=" + (Object)((Object)this.baseSeverity) + ", exploitCodeMaturity=" + (Object)((Object)this.exploitCodeMaturity) + ", remediationLevel=" + (Object)((Object)this.remediationLevel) + ", reportConfidence=" + (Object)((Object)this.reportConfidence) + ", temporalScore=" + this.temporalScore + ", temporalSeverity=" + (Object)((Object)this.temporalSeverity) + ", confidentialityRequirement=" + (Object)((Object)this.confidentialityRequirement) + ", integrityRequirement=" + (Object)((Object)this.integrityRequirement) + ", availabilityRequirement=" + (Object)((Object)this.availabilityRequirement) + ", modifiedAttackVector=" + (Object)((Object)this.modifiedAttackVector) + ", modifiedAttackComplexity=" + (Object)((Object)this.modifiedAttackComplexity) + ", modifiedPrivilegesRequired=" + (Object)((Object)this.modifiedPrivilegesRequired) + ", modifiedUserInteraction=" + (Object)((Object)this.modifiedUserInteraction) + ", modifiedScope=" + (Object)((Object)this.modifiedScope) + ", modifiedConfidentialityImpact=" + (Object)((Object)this.modifiedConfidentialityImpact) + ", modifiedIntegrityImpact=" + (Object)((Object)this.modifiedIntegrityImpact) + ", modifiedAvailabilityImpact=" + (Object)((Object)this.modifiedAvailabilityImpact) + ", environmentalScore=" + this.environmentalScore + ", environmentalSeverity=" + (Object)((Object)this.environmentalSeverity) + ", additionalProperties=" + this.additionalProperties + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CvssV31Data that = (CvssV31Data)o;
        return this.version == that.version && Objects.equals(this.vectorString, that.vectorString) && this.attackVector == that.attackVector && this.attackComplexity == that.attackComplexity && this.privilegesRequired == that.privilegesRequired && this.userInteraction == that.userInteraction && this.scope == that.scope && this.confidentialityImpact == that.confidentialityImpact && this.integrityImpact == that.integrityImpact && this.availabilityImpact == that.availabilityImpact && Objects.equals(this.baseScore, that.baseScore) && this.baseSeverity == that.baseSeverity && this.exploitCodeMaturity == that.exploitCodeMaturity && this.remediationLevel == that.remediationLevel && this.reportConfidence == that.reportConfidence && Objects.equals(this.temporalScore, that.temporalScore) && this.temporalSeverity == that.temporalSeverity && this.confidentialityRequirement == that.confidentialityRequirement && this.integrityRequirement == that.integrityRequirement && this.availabilityRequirement == that.availabilityRequirement && this.modifiedAttackVector == that.modifiedAttackVector && this.modifiedAttackComplexity == that.modifiedAttackComplexity && this.modifiedPrivilegesRequired == that.modifiedPrivilegesRequired && this.modifiedUserInteraction == that.modifiedUserInteraction && this.modifiedScope == that.modifiedScope && this.modifiedConfidentialityImpact == that.modifiedConfidentialityImpact && this.modifiedIntegrityImpact == that.modifiedIntegrityImpact && this.modifiedAvailabilityImpact == that.modifiedAvailabilityImpact && Objects.equals(this.environmentalScore, that.environmentalScore) && this.environmentalSeverity == that.environmentalSeverity && Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.vectorString, this.attackVector, this.attackComplexity, this.privilegesRequired, this.userInteraction, this.scope, this.confidentialityImpact, this.integrityImpact, this.availabilityImpact, this.baseScore, this.baseSeverity, this.exploitCodeMaturity, this.remediationLevel, this.reportConfidence, this.temporalScore, this.temporalSeverity, this.confidentialityRequirement, this.integrityRequirement, this.availabilityRequirement, this.modifiedAttackVector, this.modifiedAttackComplexity, this.modifiedPrivilegesRequired, this.modifiedUserInteraction, this.modifiedScope, this.modifiedConfidentialityImpact, this.modifiedIntegrityImpact, this.modifiedAvailabilityImpact, this.environmentalScore, this.environmentalSeverity, this.additionalProperties});
    }

    public static enum Version {
        _3_1("3.1");

        private static final Map<String, Version> CONSTANTS;
        private final String value;

        private Version(String value) {
            this.value = value;
        }

        @JsonCreator
        public static Version fromValue(String value) {
            Version constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, Version>();
            for (Version c : Version.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum UserInteractionType {
        NONE("NONE"),
        REQUIRED("REQUIRED");

        private static final Map<String, UserInteractionType> CONSTANTS;
        private final String value;

        private UserInteractionType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static UserInteractionType fromValue(String value) {
            UserInteractionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, UserInteractionType>();
            for (UserInteractionType c : UserInteractionType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum SeverityType {
        NONE("NONE"),
        LOW("LOW"),
        MEDIUM("MEDIUM"),
        HIGH("HIGH"),
        CRITICAL("CRITICAL");

        private static final Map<String, SeverityType> CONSTANTS;
        private final String value;

        private SeverityType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SeverityType fromValue(String value) {
            SeverityType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, SeverityType>();
            for (SeverityType c : SeverityType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ScopeType {
        UNCHANGED("UNCHANGED"),
        CHANGED("CHANGED");

        private static final Map<String, ScopeType> CONSTANTS;
        private final String value;

        private ScopeType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ScopeType fromValue(String value) {
            ScopeType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ScopeType>();
            for (ScopeType c : ScopeType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum RemediationLevelType {
        OFFICIAL_FIX("OFFICIAL_FIX"),
        TEMPORARY_FIX("TEMPORARY_FIX"),
        WORKAROUND("WORKAROUND"),
        UNAVAILABLE("UNAVAILABLE"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, RemediationLevelType> CONSTANTS;
        private final String value;

        private RemediationLevelType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RemediationLevelType fromValue(String value) {
            RemediationLevelType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, RemediationLevelType>();
            for (RemediationLevelType c : RemediationLevelType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum PrivilegesRequiredType {
        HIGH("HIGH"),
        LOW("LOW"),
        NONE("NONE");

        private static final Map<String, PrivilegesRequiredType> CONSTANTS;
        private final String value;

        private PrivilegesRequiredType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PrivilegesRequiredType fromValue(String value) {
            PrivilegesRequiredType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, PrivilegesRequiredType>();
            for (PrivilegesRequiredType c : PrivilegesRequiredType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ModifiedUserInteractionType {
        NONE("NONE"),
        REQUIRED("REQUIRED"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ModifiedUserInteractionType> CONSTANTS;
        private final String value;

        private ModifiedUserInteractionType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ModifiedUserInteractionType fromValue(String value) {
            ModifiedUserInteractionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ModifiedUserInteractionType>();
            for (ModifiedUserInteractionType c : ModifiedUserInteractionType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ModifiedScopeType {
        UNCHANGED("UNCHANGED"),
        CHANGED("CHANGED"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ModifiedScopeType> CONSTANTS;
        private final String value;

        private ModifiedScopeType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ModifiedScopeType fromValue(String value) {
            ModifiedScopeType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ModifiedScopeType>();
            for (ModifiedScopeType c : ModifiedScopeType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ModifiedPrivilegesRequiredType {
        HIGH("HIGH"),
        LOW("LOW"),
        NONE("NONE"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ModifiedPrivilegesRequiredType> CONSTANTS;
        private final String value;

        private ModifiedPrivilegesRequiredType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ModifiedPrivilegesRequiredType fromValue(String value) {
            ModifiedPrivilegesRequiredType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ModifiedPrivilegesRequiredType>();
            for (ModifiedPrivilegesRequiredType c : ModifiedPrivilegesRequiredType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ModifiedCiaType {
        NONE("NONE"),
        LOW("LOW"),
        HIGH("HIGH"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ModifiedCiaType> CONSTANTS;
        private final String value;

        private ModifiedCiaType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ModifiedCiaType fromValue(String value) {
            ModifiedCiaType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ModifiedCiaType>();
            for (ModifiedCiaType c : ModifiedCiaType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ModifiedAttackVectorType {
        NETWORK("NETWORK"),
        ADJACENT_NETWORK("ADJACENT_NETWORK"),
        LOCAL("LOCAL"),
        PHYSICAL("PHYSICAL"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ModifiedAttackVectorType> CONSTANTS;
        private final String value;

        private ModifiedAttackVectorType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ModifiedAttackVectorType fromValue(String value) {
            ModifiedAttackVectorType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ModifiedAttackVectorType>();
            for (ModifiedAttackVectorType c : ModifiedAttackVectorType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ModifiedAttackComplexityType {
        HIGH("HIGH"),
        LOW("LOW"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ModifiedAttackComplexityType> CONSTANTS;
        private final String value;

        private ModifiedAttackComplexityType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ModifiedAttackComplexityType fromValue(String value) {
            ModifiedAttackComplexityType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ModifiedAttackComplexityType>();
            for (ModifiedAttackComplexityType c : ModifiedAttackComplexityType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ExploitCodeMaturityType {
        UNPROVEN("UNPROVEN"),
        PROOF_OF_CONCEPT("PROOF_OF_CONCEPT"),
        FUNCTIONAL("FUNCTIONAL"),
        HIGH("HIGH"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ExploitCodeMaturityType> CONSTANTS;
        private final String value;

        private ExploitCodeMaturityType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ExploitCodeMaturityType fromValue(String value) {
            ExploitCodeMaturityType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ExploitCodeMaturityType>();
            for (ExploitCodeMaturityType c : ExploitCodeMaturityType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ConfidenceType {
        UNKNOWN("UNKNOWN"),
        REASONABLE("REASONABLE"),
        CONFIRMED("CONFIRMED"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ConfidenceType> CONSTANTS;
        private final String value;

        private ConfidenceType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ConfidenceType fromValue(String value) {
            ConfidenceType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ConfidenceType>();
            for (ConfidenceType c : ConfidenceType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum CiaType {
        NONE("NONE"),
        LOW("LOW"),
        HIGH("HIGH");

        private static final Map<String, CiaType> CONSTANTS;
        private final String value;

        private CiaType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CiaType fromValue(String value) {
            CiaType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, CiaType>();
            for (CiaType c : CiaType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum CiaRequirementType {
        LOW("LOW"),
        MEDIUM("MEDIUM"),
        HIGH("HIGH"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, CiaRequirementType> CONSTANTS;
        private final String value;

        private CiaRequirementType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CiaRequirementType fromValue(String value) {
            CiaRequirementType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, CiaRequirementType>();
            for (CiaRequirementType c : CiaRequirementType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum AttackVectorType {
        NETWORK("NETWORK"),
        ADJACENT_NETWORK("ADJACENT_NETWORK"),
        LOCAL("LOCAL"),
        PHYSICAL("PHYSICAL");

        private static final Map<String, AttackVectorType> CONSTANTS;
        private final String value;

        private AttackVectorType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AttackVectorType fromValue(String value) {
            AttackVectorType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, AttackVectorType>();
            for (AttackVectorType c : AttackVectorType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum AttackComplexityType {
        HIGH("HIGH"),
        LOW("LOW");

        private static final Map<String, AttackComplexityType> CONSTANTS;
        private final String value;

        private AttackComplexityType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AttackComplexityType fromValue(String value) {
            AttackComplexityType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, AttackComplexityType>();
            for (AttackComplexityType c : AttackComplexityType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

