/*
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 * Copyright (c) 2023-2024 Jeremy Long. All Rights Reserved.
 */
package io.github.jeremylong.openvulnerability.client.nvd;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({"cve"})
public class DefCveItem implements Serializable {

    /**
     * Serialization version UID.
     */
    private static final long serialVersionUID = 8372992609837009849L;
    /**
     * (Required)
     */
    @JsonProperty("cve")
    private CveItem cve;

    /**
     * (Required)
     *
     * @return cve
     */
    @JsonProperty("cve")
    public CveItem getCve() {
        return cve;
    }

    @Override
    public String toString() {
        return "DefCveItem{" + "cve=" + cve + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        DefCveItem that = (DefCveItem) o;
        return Objects.equals(cve, that.cve);
    }

    public DefCveItem(CveItem cve) {
        this.cve = cve;
    }

    public DefCveItem() {
    }

    @Override
    public int hashCode() {
        return Objects.hash(cve);
    }
}
