/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.openvulnerability.client.nvd;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NvdApiRetryStrategy
extends DefaultHttpRequestRetryStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(NvdApiRetryStrategy.class);
    private final int maxRetries;
    private final long delay;
    private static final String RETRY_MESSAGE_TEMPLATE = "NVD API request failures are occurring; retrying request for the {} time";

    public NvdApiRetryStrategy(int maxRetries, long delay) {
        super(maxRetries, TimeValue.of((long)delay, (TimeUnit)TimeUnit.MILLISECONDS), new ArrayList(), Arrays.asList(429, 502, 503, 504));
        this.maxRetries = maxRetries;
        this.delay = delay;
    }

    public boolean retryRequest(@Nonnull HttpRequest request, @Nonnull IOException exception, int execCount, HttpContext context) {
        this.logRetryState(request, exception, execCount);
        return super.retryRequest(request, exception, execCount, context);
    }

    public boolean retryRequest(HttpResponse response, int execCount, HttpContext context) {
        if (execCount >= this.maxRetries / 2) {
            LOG.warn(RETRY_MESSAGE_TEMPLATE, (Object)execCount);
        } else if (execCount > 1) {
            LOG.debug("Retrying request {} time", (Object)execCount);
        }
        return super.retryRequest(response, execCount, context);
    }

    private void logRetryState(@Nonnull HttpRequest request, @Nonnull IOException exception, int execCount) {
        if (execCount >= this.maxRetries / 2) {
            LOG.warn(RETRY_MESSAGE_TEMPLATE, (Object)execCount);
            if (LOG.isDebugEnabled()) {
                LOG.debug("NVD API request failures with exception : {}. Message: {}", (Object)exception.getClass().getName(), (Object)exception.getMessage());
            }
        } else if (execCount > 1) {
            LOG.warn("Retrying request {} : {} time", (Object)request.getRequestUri(), (Object)execCount);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Retrying request with exception {}. Message: {}", (Object)exception.getClass().getName(), (Object)exception.getMessage());
            }
        }
    }

    public TimeValue getRetryInterval(HttpResponse response, int execCount, HttpContext context) {
        TimeValue value = execCount < this.maxRetries / 2 ? TimeValue.of((long)(this.delay * (long)execCount), (TimeUnit)TimeUnit.MILLISECONDS) : TimeValue.of((long)(this.delay * (long)execCount / 2L), (TimeUnit)TimeUnit.MILLISECONDS);
        LOG.debug("Calculated retry interval in {} ms with execCount of {}", (Object)value.toMilliseconds(), (Object)execCount);
        Header header = response.getFirstHeader("Retry-After");
        if (header != null) {
            TimeValue retryAfter;
            block4: {
                retryAfter = null;
                String headerValue = header.getValue();
                try {
                    retryAfter = TimeValue.ofSeconds((long)Long.parseLong(headerValue));
                    LOG.debug("Retry-After header value: {} ms", (Object)retryAfter.toMilliseconds());
                }
                catch (NumberFormatException ignore) {
                    Instant retryAfterDate = DateUtils.parseStandardDate((String)headerValue);
                    if (retryAfterDate == null) break block4;
                    retryAfter = TimeValue.ofMilliseconds((long)(retryAfterDate.toEpochMilli() - System.currentTimeMillis()));
                    LOG.debug("Failed to parse value; Retry-After header value: {} ms", (Object)retryAfter.toMilliseconds());
                }
            }
            if (TimeValue.isPositive((TimeValue)retryAfter) && retryAfter.compareTo(value) < 0) {
                LOG.debug("Using Retry-After header value: {} ms", (Object)retryAfter.toMilliseconds());
                return retryAfter;
            }
        }
        LOG.debug("Using calculated retry interval: {} ms", (Object)value.toMilliseconds());
        return value;
    }
}

