/*
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 * Copyright (c) 2023-2025 Jeremy Long. All Rights Reserved.
 */
package io.github.jeremylong.openvulnerability.client.ghsa;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

/**
 * An individual package version.
 * 
 * <pre>
 * type SecurityAdvisoryPackageVersion
 * </pre>
 */
@JsonInclude(Include.NON_NULL)
public class PackageVersion implements Serializable {

    /**
     * Serialization version UID.
     */
    private static final long serialVersionUID = -4943323442084443993L;
    @JsonProperty("identifier")
    java.lang.String identifier;

    /**
     * The package name or version
     * @return the package name or version.
     */
    public java.lang.String getIdentifier() {
        return identifier;
    }

    @Override
    public String toString() {
        return "PackageVersion{" + "identifier='" + identifier + '\'' + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        PackageVersion that = (PackageVersion) o;
        return Objects.equals(identifier, that.identifier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(identifier);
    }
}
