/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.openvulnerability.client.nvd;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.jeremylong.openvulnerability.client.nvd.CvssV4Data;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"source", "type", "cvssData"})
@NullMarked
public class CvssV4
implements Serializable {
    private static final long serialVersionUID = 4239377501678853019L;
    @JsonProperty(value="source")
    private String source;
    @JsonProperty(value="type")
    private Type type;
    @JsonProperty(value="cvssData")
    private CvssV4Data cvssData;

    @JsonCreator
    public CvssV4(@JsonProperty(value="source") String source, @JsonProperty(value="type") Type type, @JsonProperty(value="cvssData") CvssV4Data cvssData) {
        this.source = source;
        this.type = type;
        this.cvssData = cvssData;
    }

    @JsonProperty(value="source")
    public String getSource() {
        return this.source;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="cvssData")
    public CvssV4Data getCvssData() {
        return this.cvssData;
    }

    public String toString() {
        return this.cvssData.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CvssV4 cvssV3 = (CvssV4)o;
        return Objects.equals(this.source, cvssV3.source) && this.type == cvssV3.type && Objects.equals(this.cvssData, cvssV3.cvssData);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.source, this.type, this.cvssData});
    }

    public static enum Type {
        PRIMARY("Primary"),
        SECONDARY("Secondary");

        private static final Map<String, Type> CONSTANTS;
        private final String value;

        private Type(String value) {
            this.value = value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

