/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.openvulnerability.client.nvd;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.jeremylong.openvulnerability.client.nvd.Node;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"operator", "negate", "nodes"})
@NullMarked
public class Config
implements Serializable {
    private static final long serialVersionUID = -6652299014788641511L;
    @JsonProperty(value="operator")
    private @Nullable Operator operator;
    @JsonProperty(value="negate")
    private @Nullable Boolean negate;
    @JsonProperty(value="nodes")
    private List<Node> nodes;

    @JsonCreator
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="I prefer to suppress these FindBugs warnings")
    public Config(@JsonProperty(value="nodes") List<Node> nodes) {
        this.nodes = nodes;
    }

    public Config(@Nullable Operator operator, @Nullable Boolean negate, List<Node> nodes) {
        this(nodes);
        this.operator = operator;
        this.negate = negate;
    }

    @JsonProperty(value="operator")
    public @Nullable Operator getOperator() {
        return this.operator;
    }

    @JsonProperty(value="negate")
    public @Nullable Boolean getNegate() {
        return this.negate;
    }

    @JsonProperty(value="nodes")
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="I prefer to suppress these FindBugs warnings")
    public List<Node> getNodes() {
        return this.nodes;
    }

    public String toString() {
        return "Config{operator=" + this.operator + ", negate=" + this.negate + ", nodes=" + this.nodes + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config config = (Config)o;
        return this.operator == config.operator && Objects.equals(this.negate, config.negate) && Objects.equals(this.nodes, config.nodes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.negate, this.nodes});
    }

    public static enum Operator {
        AND("AND"),
        OR("OR");

        private static final Map<String, Operator> CONSTANTS;
        private final String value;

        private Operator(String value) {
            this.value = value;
        }

        @JsonCreator
        public static Operator fromValue(String value) {
            Operator constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, Operator>();
            for (Operator c : Operator.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

