/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.openvulnerability.client.nvd;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.jeremylong.openvulnerability.client.nvd.Config;
import io.github.jeremylong.openvulnerability.client.nvd.CveTag;
import io.github.jeremylong.openvulnerability.client.nvd.LangString;
import io.github.jeremylong.openvulnerability.client.nvd.Metrics;
import io.github.jeremylong.openvulnerability.client.nvd.Reference;
import io.github.jeremylong.openvulnerability.client.nvd.VendorComment;
import io.github.jeremylong.openvulnerability.client.nvd.Weakness;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"id", "sourceIdentifier", "published", "lastModified", "vulnStatus", "evaluatorComment", "evaluatorSolution", "evaluatorImpact", "cisaExploitAdd", "cisaActionDue", "cisaRequiredAction", "cisaVulnerabilityName", "cveTags", "descriptions", "vendorComments", "metrics", "weaknesses", "configurations", "references"})
@NullMarked
public class CveItem
implements Serializable {
    private static final long serialVersionUID = -3429894394769351686L;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="sourceIdentifier")
    private @Nullable String sourceIdentifier;
    @JsonProperty(value="vulnStatus")
    private @Nullable String vulnStatus;
    @JsonProperty(value="published")
    @JsonFormat(pattern="uuuu-MM-dd'T'HH:mm:ss.SSS", timezone="UTC")
    private ZonedDateTime published;
    @JsonProperty(value="lastModified")
    @JsonFormat(pattern="uuuu-MM-dd'T'HH:mm:ss.SSS", timezone="UTC")
    private ZonedDateTime lastModified;
    @JsonProperty(value="evaluatorComment")
    private @Nullable String evaluatorComment;
    @JsonProperty(value="evaluatorSolution")
    private @Nullable String evaluatorSolution;
    @JsonProperty(value="evaluatorImpact")
    private @Nullable String evaluatorImpact;
    @JsonProperty(value="cisaExploitAdd")
    @JsonFormat(pattern="yyyy-MM-dd")
    private @Nullable LocalDate cisaExploitAdd;
    @JsonProperty(value="cisaActionDue")
    @JsonFormat(pattern="yyyy-MM-dd")
    private @Nullable LocalDate cisaActionDue;
    @JsonProperty(value="cisaRequiredAction")
    private @Nullable String cisaRequiredAction;
    @JsonProperty(value="cisaVulnerabilityName")
    private @Nullable String cisaVulnerabilityName;
    @JsonProperty(value="cveTags")
    private @Nullable List<CveTag> cveTags;
    @JsonProperty(value="descriptions")
    private List<LangString> descriptions;
    @JsonProperty(value="references")
    private List<Reference> references;
    @JsonProperty(value="metrics")
    @JsonPropertyDescription(value="Metric scores for a vulnerability as found on NVD.")
    private @Nullable Metrics metrics;
    @JsonProperty(value="weaknesses")
    private @Nullable List<Weakness> weaknesses;
    @JsonProperty(value="configurations")
    private @Nullable List<Config> configurations;
    @JsonProperty(value="vendorComments")
    private @Nullable List<VendorComment> vendorComments;

    @JsonCreator
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="I prefer to suppress these FindBugs warnings")
    public CveItem(@JsonProperty(value="id") String id, @JsonProperty(value="published") ZonedDateTime published, @JsonProperty(value="lastModified") ZonedDateTime lastModified, @JsonProperty(value="descriptions") List<LangString> descriptions, @JsonProperty(value="references") List<Reference> references) {
        this.id = id;
        this.published = published;
        this.lastModified = lastModified;
        this.references = references;
        this.descriptions = descriptions;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="I prefer to suppress these FindBugs warnings")
    public CveItem(String id, @Nullable String sourceIdentifier, @Nullable String vulnStatus, ZonedDateTime published, ZonedDateTime lastModified, @Nullable String evaluatorComment, @Nullable String evaluatorSolution, @Nullable String evaluatorImpact, @Nullable LocalDate cisaExploitAdd, @Nullable LocalDate cisaActionDue, @Nullable String cisaRequiredAction, @Nullable String cisaVulnerabilityName, @Nullable List<CveTag> cveTags, List<LangString> descriptions, List<Reference> references, @Nullable Metrics metrics, @Nullable List<Weakness> weaknesses, @Nullable List<Config> configurations, @Nullable List<VendorComment> vendorComments) {
        this(id, published, lastModified, descriptions, references);
        this.sourceIdentifier = sourceIdentifier;
        this.vulnStatus = vulnStatus;
        this.evaluatorComment = evaluatorComment;
        this.evaluatorSolution = evaluatorSolution;
        this.evaluatorImpact = evaluatorImpact;
        this.cisaExploitAdd = cisaExploitAdd;
        this.cisaActionDue = cisaActionDue;
        this.cisaRequiredAction = cisaRequiredAction;
        this.cisaVulnerabilityName = cisaVulnerabilityName;
        this.cveTags = cveTags;
        this.metrics = metrics;
        this.weaknesses = weaknesses;
        this.configurations = configurations;
        this.vendorComments = vendorComments;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="sourceIdentifier")
    public @Nullable String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    @JsonProperty(value="vulnStatus")
    public @Nullable String getVulnStatus() {
        return this.vulnStatus;
    }

    @JsonProperty(value="published")
    public ZonedDateTime getPublished() {
        return this.published;
    }

    @JsonProperty(value="lastModified")
    public ZonedDateTime getLastModified() {
        return this.lastModified;
    }

    @JsonProperty(value="evaluatorComment")
    public @Nullable String getEvaluatorComment() {
        return this.evaluatorComment;
    }

    @JsonProperty(value="evaluatorSolution")
    public @Nullable String getEvaluatorSolution() {
        return this.evaluatorSolution;
    }

    @JsonProperty(value="evaluatorImpact")
    public @Nullable String getEvaluatorImpact() {
        return this.evaluatorImpact;
    }

    @JsonProperty(value="cisaExploitAdd")
    public @Nullable LocalDate getCisaExploitAdd() {
        return this.cisaExploitAdd;
    }

    @JsonProperty(value="cisaActionDue")
    public @Nullable LocalDate getCisaActionDue() {
        return this.cisaActionDue;
    }

    @JsonProperty(value="cisaRequiredAction")
    public @Nullable String getCisaRequiredAction() {
        return this.cisaRequiredAction;
    }

    @JsonProperty(value="cisaVulnerabilityName")
    public @Nullable String getCisaVulnerabilityName() {
        return this.cisaVulnerabilityName;
    }

    @JsonProperty(value="cveTags")
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="I prefer to suppress these FindBugs warnings")
    public @Nullable List<CveTag> getCveTags() {
        return this.cveTags;
    }

    @JsonProperty(value="descriptions")
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="I prefer to suppress these FindBugs warnings")
    public List<LangString> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="references")
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="I prefer to suppress these FindBugs warnings")
    public List<Reference> getReferences() {
        return this.references;
    }

    @JsonProperty(value="metrics")
    public @Nullable Metrics getMetrics() {
        return this.metrics;
    }

    @JsonProperty(value="weaknesses")
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="I prefer to suppress these FindBugs warnings")
    public @Nullable List<Weakness> getWeaknesses() {
        return this.weaknesses;
    }

    @JsonProperty(value="configurations")
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="I prefer to suppress these FindBugs warnings")
    public @Nullable List<Config> getConfigurations() {
        return this.configurations;
    }

    @JsonProperty(value="vendorComments")
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="I prefer to suppress these FindBugs warnings")
    public @Nullable List<VendorComment> getVendorComments() {
        return this.vendorComments;
    }

    public String toString() {
        return "CveItem{id='" + this.id + "', sourceIdentifier='" + this.sourceIdentifier + "', vulnStatus='" + this.vulnStatus + "', published=" + this.published + ", lastModified=" + this.lastModified + ", evaluatorComment='" + this.evaluatorComment + "', evaluatorSolution='" + this.evaluatorSolution + "', evaluatorImpact='" + this.evaluatorImpact + "', cisaExploitAdd=" + this.cisaExploitAdd + ", cisaActionDue=" + this.cisaActionDue + ", cisaRequiredAction='" + this.cisaRequiredAction + "', cisaVulnerabilityName='" + this.cisaVulnerabilityName + "', cveTags=" + this.cveTags + ", descriptions=" + this.descriptions + ", references=" + this.references + ", metrics=" + this.metrics + ", weaknesses=" + this.weaknesses + ", configurations=" + this.configurations + ", vendorComments=" + this.vendorComments + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CveItem cveItem = (CveItem)o;
        return Objects.equals(this.id, cveItem.id) && Objects.equals(this.sourceIdentifier, cveItem.sourceIdentifier) && Objects.equals(this.vulnStatus, cveItem.vulnStatus) && Objects.equals(this.published, cveItem.published) && Objects.equals(this.lastModified, cveItem.lastModified) && Objects.equals(this.evaluatorComment, cveItem.evaluatorComment) && Objects.equals(this.evaluatorSolution, cveItem.evaluatorSolution) && Objects.equals(this.evaluatorImpact, cveItem.evaluatorImpact) && Objects.equals(this.cisaExploitAdd, cveItem.cisaExploitAdd) && Objects.equals(this.cisaActionDue, cveItem.cisaActionDue) && Objects.equals(this.cisaRequiredAction, cveItem.cisaRequiredAction) && Objects.equals(this.cisaVulnerabilityName, cveItem.cisaVulnerabilityName) && Objects.equals(this.cveTags, cveItem.cveTags) && Objects.equals(this.descriptions, cveItem.descriptions) && Objects.equals(this.references, cveItem.references) && Objects.equals(this.metrics, cveItem.metrics) && Objects.equals(this.weaknesses, cveItem.weaknesses) && Objects.equals(this.configurations, cveItem.configurations) && Objects.equals(this.vendorComments, cveItem.vendorComments);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.sourceIdentifier, this.vulnStatus, this.published, this.lastModified, this.evaluatorComment, this.evaluatorSolution, this.evaluatorImpact, this.cisaExploitAdd, this.cisaActionDue, this.cisaRequiredAction, this.cisaVulnerabilityName, this.cveTags, this.descriptions, this.references, this.metrics, this.weaknesses, this.configurations, this.vendorComments);
    }
}

