/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.openvulnerability.client.nvd;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.jeremylong.openvulnerability.client.ForcedDiskCacheStorage;
import io.github.jeremylong.openvulnerability.client.HttpAsyncClientSupplier;
import io.github.jeremylong.openvulnerability.client.nvd.NvdApiException;
import io.github.jeremylong.openvulnerability.client.nvd.NvdApiRetryStrategy;
import io.github.jeremylong.openvulnerability.client.nvd.RateLimitedCall;
import io.github.jeremylong.openvulnerability.client.nvd.RateMeter;
import java.io.File;
import java.io.IOException;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.HttpCacheStorage;
import org.apache.hc.client5.http.cache.ResourceIOException;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.CacheKeyGenerator;
import org.apache.hc.client5.http.impl.cache.CachingHttpAsyncClients;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.SystemDefaultRoutePlanner;
import org.apache.hc.client5.http.impl.schedule.ImmediateSchedulingStrategy;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.schedule.SchedulingStrategy;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RateLimitedClient
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(RateLimitedClient.class);
    private final CloseableHttpAsyncClient client;
    private final ExecutorService executor = new PrioritizedExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, Executors.defaultThreadFactory());
    private long lastRequest = 0L;
    private long delay;
    private final RateMeter meter;
    ForcedDiskCacheStorage cacheStorage = null;

    RateLimitedClient() {
        this(0L, 0, false);
    }

    RateLimitedClient(boolean hasApiKey) {
        this(0L, 0, hasApiKey);
    }

    RateLimitedClient(int requestsPerThirtySeconds) {
        this(0L, requestsPerThirtySeconds, false);
    }

    RateLimitedClient(long delay, int requestsPerThirtySeconds, boolean hasApiKey) {
        this(10, delay, requestsPerThirtySeconds, null, hasApiKey);
    }

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    RateLimitedClient(int maxRetries, long minimumDelay, int requestsPerThirtySeconds, HttpAsyncClientSupplier httpClientSupplier, boolean hasApiKey) {
        this(maxRetries, minimumDelay, requestsPerThirtySeconds, httpClientSupplier, null, hasApiKey);
    }

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    RateLimitedClient(int maxRetries, long minimumDelay, int requestsPerThirtySeconds, HttpAsyncClientSupplier httpClientSupplier, Path cachePath, boolean hasApiKey) {
        int rate = 5;
        if (hasApiKey) {
            rate = 50;
        }
        if (requestsPerThirtySeconds > 0 && requestsPerThirtySeconds < rate) {
            rate = requestsPerThirtySeconds;
        }
        this.meter = new RateMeter(rate, 32500L);
        this.delay = Math.max(1L, (long)Math.ceil((double)this.meter.getQuantity() / (double)this.meter.getDuration()));
        if (minimumDelay > 0L && minimumDelay > this.delay) {
            this.delay = minimumDelay;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("rate limited calls: {}/30s", (Object)rate);
            LOG.debug("rate limited call delay: {}", (Object)this.delay);
        }
        if (httpClientSupplier == null) {
            NvdApiRetryStrategy retryStrategy = new NvdApiRetryStrategy(maxRetries, minimumDelay);
            SystemDefaultRoutePlanner planner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
            PoolingAsyncClientConnectionManager connectionManager = PoolingAsyncClientConnectionManagerBuilder.create().setDefaultConnectionConfig(ConnectionConfig.custom().setSocketTimeout(Timeout.ofMinutes((long)1L)).setConnectTimeout(Timeout.ofMinutes((long)1L)).build()).useSystemProperties().build();
            if (cachePath == null) {
                this.client = HttpAsyncClients.custom().setRoutePlanner((HttpRoutePlanner)planner).setRetryStrategy((HttpRequestRetryStrategy)retryStrategy).setConnectionManager((AsyncClientConnectionManager)connectionManager).useSystemProperties().build();
            } else {
                File cacheDir = cachePath.toFile();
                if (!cacheDir.exists() && !cacheDir.mkdirs()) {
                    throw new NvdApiException("Unable to create http cache directory: " + cacheDir.getAbsolutePath());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using http cache directory: {}", (Object)cacheDir.getAbsolutePath());
                }
                CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(1000).setMaxObjectSize(20000000L).setSharedCache(true).setHeuristicCachingEnabled(true).setHeuristicDefaultLifetime(TimeValue.of((Duration)Duration.ofHours(20L))).setNeverCacheHTTP10ResponsesWithQueryString(true).setNeverCacheHTTP11ResponsesWithQueryString(true).setWeakETagOnPutDeleteAllowed(true).build();
                try {
                    this.cacheStorage = new ForcedDiskCacheStorage(cacheDir.getAbsolutePath(), Duration.ofHours(20L));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.client = CachingHttpAsyncClients.custom().setCacheConfig(cacheConfig).setHttpCacheStorage((HttpCacheStorage)this.cacheStorage).setDeleteCache(false).setSchedulingStrategy((SchedulingStrategy)ImmediateSchedulingStrategy.INSTANCE).setRoutePlanner((HttpRoutePlanner)planner).setRetryStrategy((HttpRequestRetryStrategy)retryStrategy).useSystemProperties().setConnectionManager((AsyncClientConnectionManager)connectionManager).useSystemProperties().build();
            }
        } else {
            this.client = (CloseableHttpAsyncClient)httpClientSupplier.get();
        }
        this.client.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.close();
            }
            catch (Exception e) {
                LOG.error("Error closing RateLimitedClient during shutdown", (Throwable)e);
            }
        }));
    }

    @Override
    public void close() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
        this.executor.shutdown();
    }

    public long getDelay() {
        return this.delay;
    }

    void setDelay(long milliseconds) {
        this.delay = milliseconds;
        if (LOG.isDebugEnabled()) {
            LOG.debug("rate limited call delay: {}", (Object)this.delay);
        }
    }

    Future<RateLimitedCall> execute(SimpleHttpRequest request, int startIndex) {
        return this.executor.submit(new PrioritizedCallable<RateLimitedCall>(() -> this.delayedExecute(request, startIndex), startIndex));
    }

    private RateLimitedCall delayedExecute(SimpleHttpRequest request, int startIndex) throws ExecutionException, InterruptedException {
        long now;
        long wait;
        request.addHeader("Cache-Control", (Object)"max-age=72000");
        if (this.cacheStorage != null) {
            try {
                String key = CacheKeyGenerator.INSTANCE.generateKey(request.getUri());
                HttpCacheEntry entry = this.cacheStorage.getEntry(key);
                if (entry != null) {
                    Future f = this.client.execute(request, (FutureCallback)new SimpleFutureResponse());
                    return new RateLimitedCall((SimpleHttpResponse)f.get(), startIndex);
                }
            }
            catch (URISyntaxException | ResourceIOException key) {
                // empty catch block
            }
        }
        if (this.lastRequest > 0L && this.delay > 0L && (wait = this.delay - ((now = ZonedDateTime.now().toInstant().toEpochMilli()) - this.lastRequest)) > 0L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Rate Limited API call - waiting for {}ms", (Object)wait);
            }
            Thread.sleep(wait);
        }
        try {
            this.meter.checkRateLimit();
            if (LOG.isDebugEnabled()) {
                LocalTime time = LocalTime.now();
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Requested At: {}; URI: {}", (Object)time.format(formatter), (Object)request.getRequestUri());
                }
            }
            Future f = this.client.execute(request, (FutureCallback)new SimpleFutureResponse());
            this.lastRequest = ZonedDateTime.now().toInstant().toEpochMilli();
            return new RateLimitedCall((SimpleHttpResponse)f.get(), startIndex);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            if (e instanceof ExecutionException) {
                throw (ExecutionException)e;
            }
            throw new NvdApiException(e);
        }
    }

    private static class PrioritizedExecutor
    extends ThreadPoolExecutor {
        public PrioritizedExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new PriorityBlockingQueue<Runnable>(), threadFactory);
        }

        @Override
        public Future<?> submit(Runnable task) {
            if (task instanceof PrioritizedFutureTask) {
                this.execute(task);
                return (Future)((Object)task);
            }
            return super.submit(task);
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            if (task instanceof PrioritizedCallable) {
                PrioritizedCallable prioritizedTask = (PrioritizedCallable)task;
                PrioritizedFutureTask futureTask = new PrioritizedFutureTask(prioritizedTask, prioritizedTask.getStartIndex());
                this.execute(futureTask);
                return futureTask;
            }
            return super.submit(task);
        }
    }

    private static class PrioritizedCallable<T>
    implements Callable<T> {
        private final Callable<T> task;
        private final int startIndex;

        public PrioritizedCallable(Callable<T> task, int startIndex) {
            this.task = task;
            this.startIndex = startIndex;
        }

        @Override
        public T call() throws Exception {
            return this.task.call();
        }

        public int getStartIndex() {
            return this.startIndex;
        }
    }

    static class SimpleFutureResponse
    implements FutureCallback<SimpleHttpResponse> {
        private final Logger log = LoggerFactory.getLogger(SimpleFutureResponse.class);

        SimpleFutureResponse() {
        }

        public void completed(SimpleHttpResponse result) {
        }

        public void failed(Exception ex) {
            this.log.debug("request failed", (Throwable)ex);
        }

        public void cancelled() {
        }
    }

    private static class PrioritizedFutureTask<T>
    extends FutureTask<T>
    implements Comparable<PrioritizedFutureTask<T>> {
        private final int startIndex;

        public PrioritizedFutureTask(Callable<T> callable, int startIndex) {
            super(callable);
            this.startIndex = startIndex;
        }

        @Override
        public int compareTo(PrioritizedFutureTask<T> other) {
            return Integer.compare(this.startIndex, other.startIndex);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PrioritizedFutureTask that = (PrioritizedFutureTask)o;
            return this.startIndex == that.startIndex;
        }

        public int hashCode() {
            return Objects.hash(this.startIndex);
        }
    }
}

