/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeschkies.loki.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.github.jeschkies.loki.client.LokiClientConfig;
import io.github.jeschkies.loki.client.LokiClientException;
import io.github.jeschkies.loki.client.Time;
import io.github.jeschkies.loki.client.model.Data;
import io.github.jeschkies.loki.client.model.QueryResult;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class LokiClient {
    private final OkHttpClient httpClient;
    private final URI lokiEndpoint;
    private static final MediaType JsonMediaType = MediaType.parse((String)"application/json");

    public LokiClient(LokiClientConfig config) {
        this.lokiEndpoint = config.uri();
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().readTimeout(Duration.ofMillis(config.readTimeout().toMillis()));
        this.httpClient = clientBuilder.build();
    }

    public QueryResult rangeQuery(String lokiQuery, Instant start, Instant end) throws LokiClientException {
        return this.rangeQuery(lokiQuery, start, end, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QueryResult rangeQuery(String lokiQuery, Instant start, Instant end, int stepSeconds) throws LokiClientException {
        HttpUrl.Builder uriBuilder = new HttpUrl.Builder().scheme(this.lokiEndpoint.getScheme()).host(this.lokiEndpoint.getHost()).port(this.lokiEndpoint.getPort()).addPathSegments("loki/api/v1/query_range").addQueryParameter("query", lokiQuery).addQueryParameter("start", Time.nanosFromInstant(start).toString()).addQueryParameter("end", Time.nanosFromInstant(end).toString()).addQueryParameter("direction", "forward");
        if (stepSeconds != 0) {
            uriBuilder.addQueryParameter("step", String.format("%ds", stepSeconds));
        }
        URI uri = uriBuilder.build().uri();
        try (Response response = this.requestUri(uri);){
            if (response.isSuccessful() && response.body() != null) {
                QueryResult queryResult = QueryResult.fromJSON(response.body().byteStream());
                return queryResult;
            }
            String error = response.code() + ": " + response.message();
            if (response.body() == null) throw new LokiClientException(error);
            error = error + " " + response.body().string();
            throw new LokiClientException(error);
        }
        catch (IOException e) {
            throw new LokiClientException("Error reading range query", e);
        }
    }

    public void pushLogLine(String log, Instant timestamp, Map<String, String> labels) throws IOException, LokiClientException {
        URI uri = new HttpUrl.Builder().scheme(this.lokiEndpoint.getScheme()).host(this.lokiEndpoint.getHost()).port(this.lokiEndpoint.getPort()).addPathSegments("loki/api/v1/push").build().uri();
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode root = mapper.createObjectNode();
        ArrayNode streams = mapper.createArrayNode();
        ObjectNode stream = mapper.createObjectNode();
        ObjectNode lbls = mapper.createObjectNode();
        for (Map.Entry<String, String> pair : labels.entrySet()) {
            lbls.put(pair.getKey(), pair.getValue());
        }
        ArrayNode values = mapper.createArrayNode();
        ArrayNode line = mapper.createArrayNode();
        line.add(Time.nanosFromInstant(timestamp).toString());
        line.add(log);
        values.add((JsonNode)line);
        stream.set("stream", (JsonNode)lbls);
        stream.set("values", (JsonNode)values);
        streams.add((JsonNode)stream);
        root.set("streams", (JsonNode)streams);
        String bodyStr = mapper.writeValueAsString((Object)root);
        RequestBody body = RequestBody.create((String)bodyStr, (MediaType)JsonMediaType);
        Request.Builder requestBuilder = new Request.Builder().post(body).url(uri.toString());
        try (Response response = this.httpClient.newCall(requestBuilder.build()).execute();){
            if (!response.isSuccessful()) {
                Object error = "";
                if (response.body() != null) {
                    error = ": " + response.body().string();
                }
                throw new LokiClientException("Bad response " + response.code() + " " + response.message() + (String)error);
            }
        }
    }

    public void flush() throws IOException, LokiClientException {
        URI uri = new HttpUrl.Builder().scheme(this.lokiEndpoint.getScheme()).host(this.lokiEndpoint.getHost()).port(this.lokiEndpoint.getPort()).addPathSegment("flush").build().uri();
        Request.Builder requestBuilder = new Request.Builder().post(RequestBody.create((String)"", (MediaType)JsonMediaType)).url(uri.toString());
        try (Response response = this.httpClient.newCall(requestBuilder.build()).execute();){
            if (!response.isSuccessful()) {
                throw new LokiClientException("Bad response " + response.code() + " " + response.message());
            }
        }
    }

    public Response requestUri(URI uri) throws IOException {
        Request.Builder requestBuilder = new Request.Builder().url(uri.toString());
        return this.httpClient.newCall(requestBuilder.build()).execute();
    }

    public Data.ResultType getExpectedResultType(String query) throws LokiClientException {
        QueryResult result = this.rangeQuery(query, Instant.now().minus(Duration.ofNanos(1L)), Instant.now(), 0);
        return result.getData().getResultType();
    }
}

