/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.hephaistos.json;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.Closeable;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.hephaistos.nbt.CompoundBuilder;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTEnd;
import org.jglrxavpok.hephaistos.nbt.NBTException;
import org.jglrxavpok.hephaistos.nbt.NBTList;
import org.jglrxavpok.hephaistos.nbt.NBTString;
import org.jglrxavpok.hephaistos.nbt.NBTType;
import org.jglrxavpok.hephaistos.nbt.mutable.MutableNBTCompound;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u00012\u00020\u0002:\u0001\u0012B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0002H\t\"\n\b\u0000\u0010\t\u0018\u0001*\u00020\nH\u0086\b\u00a2\u0006\u0002\u0010\u000bJ#\u0010\b\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\r\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\b\u001a\u00020\n2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0010J\u0006\u0010\u0011\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jglrxavpok/hephaistos/json/NBTGsonReader;", "Ljava/lang/AutoCloseable;", "Ljava/io/Closeable;", "reader", "Ljava/io/Reader;", "(Ljava/io/Reader;)V", "close", "", "read", "Tag", "Lorg/jglrxavpok/hephaistos/nbt/NBT;", "()Lorg/jglrxavpok/hephaistos/nbt/NBT;", "nbtClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Lorg/jglrxavpok/hephaistos/nbt/NBT;", "nbtType", "Lorg/jglrxavpok/hephaistos/nbt/NBTType;", "readWithGuess", "Companion", "gson"})
public final class NBTGsonReader
implements AutoCloseable,
Closeable {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Reader reader;
    @Deprecated
    @NotNull
    private static final Gson GsonInstance = new Gson();

    public NBTGsonReader(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.reader = reader;
    }

    public final /* synthetic */ <Tag extends NBT> Tag read() {
        boolean $i$f$read = false;
        NBTType.Companion this_$iv = NBTType.Companion;
        boolean $i$f$byClass = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"Tag");
        NBTType nBTType = this_$iv.byClass(Reflection.getOrCreateKotlinClass(NBT.class));
        if (nBTType == null) {
            Intrinsics.reifiedOperationMarker((int)4, (String)"Tag");
            String string = Intrinsics.stringPlus((String)"Invalid NBTType: ", (Object)Reflection.getOrCreateKotlinClass(NBT.class).getQualifiedName());
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        NBT nBT = this.read((NBTType<? extends NBT>)nBTType);
        Intrinsics.reifiedOperationMarker((int)1, (String)"Tag");
        return (Tag)nBT;
    }

    @NotNull
    public final <Tag extends NBT> Tag read(@NotNull Class<Tag> nbtClass) {
        Intrinsics.checkNotNullParameter(nbtClass, (String)"nbtClass");
        NBTType nBTType = NBTType.Companion.byClass(nbtClass);
        if (nBTType == null) {
            String string = Intrinsics.stringPlus((String)"Invalid NBTType: ", (Object)nbtClass.getCanonicalName());
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return (Tag)this.read((NBTType<? extends NBT>)nBTType);
    }

    @NotNull
    public final NBT read(@NotNull NBTType<? extends NBT> nbtType) {
        Intrinsics.checkNotNullParameter(nbtType, (String)"nbtType");
        Object object = GsonInstance.fromJson(this.reader, JsonElement.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"GsonInstance.fromJson(reader, JsonElement::class.java)");
        return Companion.parse(nbtType, (JsonElement)object);
    }

    @NotNull
    public final NBT readWithGuess() {
        JsonElement element = (JsonElement)GsonInstance.fromJson(this.reader, JsonElement.class);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"element");
        return Companion.parse((NBTType<? extends NBT>)NBTGsonReader.Companion.guessType(element), element);
    }

    @Override
    public void close() {
        this.reader.close();
    }

    @JvmStatic
    @NotNull
    public static final <Tag extends NBT> Tag parse(@NotNull NBTType<? extends NBT> nbtType, @NotNull JsonElement element) {
        return Companion.parse(nbtType, element);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0003J/\u0010\f\u001a\u0002H\r\"\b\b\u0000\u0010\r*\u00020\t2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0003R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/jglrxavpok/hephaistos/json/NBTGsonReader$Companion;", "", "()V", "GsonInstance", "Lcom/google/gson/Gson;", "getGsonInstance", "()Lcom/google/gson/Gson;", "guessType", "Lorg/jglrxavpok/hephaistos/nbt/NBTType;", "Lorg/jglrxavpok/hephaistos/nbt/NBT;", "element", "Lcom/google/gson/JsonElement;", "parse", "Tag", "nbtType", "(Lorg/jglrxavpok/hephaistos/nbt/NBTType;Lcom/google/gson/JsonElement;)Lorg/jglrxavpok/hephaistos/nbt/NBT;", "toCompound", "Lorg/jglrxavpok/hephaistos/nbt/NBTCompound;", "jsonObject", "Lcom/google/gson/JsonObject;", "gson"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Gson getGsonInstance() {
            return GsonInstance;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final <Tag extends NBT> Tag parse(@NotNull NBTType<? extends NBT> nbtType, @NotNull JsonElement element) {
            Intrinsics.checkNotNullParameter(nbtType, (String)"nbtType");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            try {
                Object object;
                Object object2;
                JsonElement it;
                Collection<Byte> collection;
                Iterator iterator;
                Object $this$mapTo$iv$iv;
                Object $this$map$iv;
                NBT.Companion companion;
                NBT nBT;
                NBTType<? extends NBT> nBTType = nbtType;
                if (Intrinsics.areEqual(nBTType, (Object)NBTType.TAG_End)) {
                    nBT = (NBT)NBTEnd.INSTANCE;
                } else if (Intrinsics.areEqual(nBTType, (Object)NBTType.TAG_Byte)) {
                    nBT = (NBT)NBT.Companion.Byte(element.getAsByte());
                } else if (Intrinsics.areEqual(nBTType, (Object)NBTType.TAG_Short)) {
                    nBT = (NBT)NBT.Companion.Short(element.getAsShort());
                } else if (Intrinsics.areEqual(nBTType, (Object)NBTType.TAG_Int)) {
                    nBT = (NBT)NBT.Companion.Int(element.getAsInt());
                } else if (Intrinsics.areEqual(nBTType, (Object)NBTType.TAG_Long)) {
                    nBT = (NBT)NBT.Companion.Long(element.getAsLong());
                } else if (Intrinsics.areEqual(nBTType, (Object)NBTType.TAG_Float)) {
                    nBT = (NBT)NBT.Companion.Float(element.getAsFloat());
                } else if (Intrinsics.areEqual(nBTType, (Object)NBTType.TAG_Double)) {
                    nBT = (NBT)NBT.Companion.Double(element.getAsDouble());
                } else if (Intrinsics.areEqual(nBTType, (Object)NBTType.TAG_Byte_Array)) {
                    Object object3 = element.getAsJsonArray();
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"element.asJsonArray");
                    object3 = (Iterable)object3;
                    companion = NBT.Companion;
                    boolean $i$f$map = false;
                    void var8_10 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Object item$iv$iv = iterator.next();
                        JsonElement jsonElement = (JsonElement)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        object2 = it.getAsByte();
                        collection.add((Byte)object2);
                    }
                    collection = (List)destination$iv$iv;
                    object = CollectionsKt.toByteArray((Collection)collection);
                    nBT = (NBT)companion.ByteArray(Arrays.copyOf((byte[])object, ((Object)object).length));
                } else if (Intrinsics.areEqual(nBTType, (Object)NBTType.TAG_String)) {
                    NBTString nBTString;
                    if (element.isJsonNull()) {
                        nBTString = NBT.Companion.String("");
                    } else {
                        object = element.getAsString();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element.asString");
                        nBTString = NBT.Companion.String((String)object);
                    }
                    nBT = (NBT)nBTString;
                } else if (Intrinsics.areEqual(nBTType, (Object)NBTType.TAG_Compound)) {
                    object = element.getAsJsonObject();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element.asJsonObject");
                    nBT = (NBT)this.toCompound((JsonObject)object);
                } else if (Intrinsics.areEqual(nBTType, (Object)NBTType.TAG_Int_Array)) {
                    $this$map$iv = element.getAsJsonArray();
                    Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv, (String)"element.asJsonArray");
                    $this$map$iv = (Iterable)$this$map$iv;
                    companion = NBT.Companion;
                    boolean $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Object item$iv$iv = iterator.next();
                        it = (JsonElement)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        object2 = it.getAsInt();
                        collection.add((Byte)object2);
                    }
                    collection = (List)destination$iv$iv;
                    object = CollectionsKt.toIntArray(collection);
                    nBT = (NBT)companion.IntArray(Arrays.copyOf((int[])object, ((Object)object).length));
                } else if (Intrinsics.areEqual(nBTType, (Object)NBTType.TAG_Long_Array)) {
                    $this$map$iv = element.getAsJsonArray();
                    Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv, (String)"element.asJsonArray");
                    $this$map$iv = (Iterable)$this$map$iv;
                    companion = NBT.Companion;
                    boolean $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Object item$iv$iv = iterator.next();
                        it = (JsonElement)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        object2 = it.getAsLong();
                        collection.add((Byte)object2);
                    }
                    collection = (List)destination$iv$iv;
                    object = CollectionsKt.toLongArray(collection);
                    nBT = (NBT)companion.LongArray(Arrays.copyOf((long[])object, ((Object)object).length));
                } else if (Intrinsics.areEqual(nBTType, (Object)NBTType.TAG_List)) {
                    NBTList nBTList;
                    if (!element.isJsonArray()) {
                        throw new NBTException(Intrinsics.stringPlus((String)"Expected a list, but was: ", (Object)element), null, 2, null);
                    }
                    JsonArray elements = element.getAsJsonArray();
                    if (elements.size() == 0) {
                        nBTList = NBT.Companion.List$default((NBT.Companion)NBT.Companion, (NBTType)NBTType.TAG_String, null, (int)2, null);
                    } else {
                        NBTList list;
                        void $this$mapTo$iv$iv2;
                        void $this$map$iv2;
                        JsonElement $i$f$map = elements.get(0);
                        Intrinsics.checkNotNullExpressionValue((Object)$i$f$map, (String)"elements[0]");
                        NBTType<? extends NBT> nBTType2 = this.guessType($i$f$map);
                        $i$f$map = elements.get(0);
                        Intrinsics.checkNotNullExpressionValue((Object)$i$f$map, (String)"elements[0]");
                        Tag firstElement = this.parse(nBTType2, $i$f$map);
                        NBTType nBTType3 = firstElement.getID();
                        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"elements");
                        $this$mapTo$iv$iv = (Iterable)elements;
                        collection = nBTType3;
                        companion = NBT.Companion;
                        boolean $i$f$map2 = false;
                        void $i$f$mapTo = $this$map$iv2;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo2 = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                            void it2;
                            JsonElement jsonElement = (JsonElement)item$iv$iv;
                            object2 = destination$iv$iv;
                            boolean bl = false;
                            Companion companion2 = Companion;
                            NBTType nBTType4 = firstElement.getID();
                            Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                            Tag Tag = companion2.parse((NBTType<? extends NBT>)nBTType4, (JsonElement)it2);
                            object2.add(Tag);
                        }
                        object2 = (List)destination$iv$iv;
                        nBTList = list = companion.List(collection, (List)object2);
                    }
                    nBT = (NBT)nBTList;
                } else {
                    throw new IllegalArgumentException(nbtType + " is not a valid/supported NBT type");
                }
                NBT result = nBT;
                return (Tag)result;
            }
            catch (IllegalStateException e) {
                throw new NBTException("Failed to load NBT from json", (Throwable)e);
            }
        }

        @JvmStatic
        private final NBTCompound toCompound(JsonObject jsonObject) {
            NBT.Companion this_$iv = NBT.Companion;
            boolean $i$f$Kompound = false;
            return this_$iv.Compound(new CompoundBuilder(jsonObject){
                final /* synthetic */ JsonObject $jsonObject$inlined;
                {
                    this.$jsonObject$inlined = jsonObject;
                }

                public final void run(@NotNull MutableNBTCompound it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    MutableNBTCompound $this$toCompound_u24lambda_u2d4 = it;
                    boolean bl = false;
                    for (Map.Entry entry : this.$jsonObject$inlined.entrySet()) {
                        Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"jsonObject.entrySet()");
                        Map.Entry entry2 = entry;
                        boolean bl2 = false;
                        String key = (String)entry2.getKey();
                        Map.Entry entry3 = entry;
                        boolean bl3 = false;
                        JsonElement value = (JsonElement)entry3.getValue();
                        Companion companion = NBTGsonReader.access$getCompanion$p();
                        Companion companion2 = NBTGsonReader.access$getCompanion$p();
                        Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                        Tag nbt = companion.parse((NBTType<? extends NBT>)org.jglrxavpok.hephaistos.json.NBTGsonReader$Companion.access$guessType(companion2, value), value);
                        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                        $this$toCompound_u24lambda_u2d4.set(key, nbt);
                    }
                }
            });
        }

        /*
         * Enabled aggressive block sorting
         */
        @JvmStatic
        private final NBTType<? extends NBT> guessType(JsonElement element) {
            NBTType<? extends NBT> guessedType;
            NBTType nBTType;
            if (element.isJsonObject()) {
                nBTType = NBTType.TAG_Compound;
                return nBTType;
            }
            if (element.isJsonNull()) {
                nBTType = NBTType.TAG_String;
                return nBTType;
            }
            if (element.isJsonPrimitive()) {
                JsonPrimitive primitive = element.getAsJsonPrimitive();
                if (primitive.isBoolean()) {
                    nBTType = NBTType.TAG_Byte;
                    return nBTType;
                }
                if (primitive.isString()) {
                    nBTType = NBTType.TAG_String;
                    return nBTType;
                }
                if (!primitive.isNumber()) {
                    String string = "Primitive that is neither a boolean, a string, nor a number?";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                if (!((double)primitive.getAsLong() == primitive.getAsDouble())) {
                    nBTType = NBTType.TAG_Double;
                    return nBTType;
                }
                String string = primitive.getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"primitive.asString");
                if (StringsKt.contains$default((CharSequence)string, (char)'.', (boolean)false, (int)2, null)) {
                    nBTType = NBTType.TAG_Double;
                    return nBTType;
                }
                nBTType = NBTType.TAG_Long;
                return nBTType;
            }
            if (!element.isJsonArray()) {
                String string = Intrinsics.stringPlus((String)"Unknown json element type ", (Object)element);
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            JsonArray array = element.getAsJsonArray();
            if (array.size() == 0) {
                nBTType = NBTType.TAG_List;
                return nBTType;
            }
            JsonElement firstElement = element.getAsJsonArray().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)firstElement, (String)"firstElement");
            NBTType<? extends NBT> nBTType2 = guessedType = this.guessType(firstElement);
            if (Intrinsics.areEqual(nBTType2, (Object)NBTType.TAG_Long)) {
                nBTType = NBTType.TAG_Long_Array;
                return nBTType;
            }
            if (Intrinsics.areEqual(nBTType2, (Object)NBTType.TAG_Byte)) {
                nBTType = NBTType.TAG_Byte_Array;
                return nBTType;
            }
            if (Intrinsics.areEqual(nBTType2, (Object)NBTType.TAG_Int)) {
                nBTType = NBTType.TAG_Int_Array;
                return nBTType;
            }
            nBTType = NBTType.TAG_List;
            return nBTType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

