/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.hephaistos.json;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTByteArray;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTEnd;
import org.jglrxavpok.hephaistos.nbt.NBTException;
import org.jglrxavpok.hephaistos.nbt.NBTIntArray;
import org.jglrxavpok.hephaistos.nbt.NBTList;
import org.jglrxavpok.hephaistos.nbt.NBTLongArray;
import org.jglrxavpok.hephaistos.nbt.NBTNumber;
import org.jglrxavpok.hephaistos.nbt.NBTString;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0011\b\u0000\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0002"}, d2={"Lorg/jglrxavpok/hephaistos/json/NBTGsonWriter;", "", "gson", "Lcom/google/gson/Gson;", "(Lcom/google/gson/Gson;)V", "getGson", "()Lcom/google/gson/Gson;", "write", "Lcom/google/gson/JsonElement;", "element", "Lorg/jglrxavpok/hephaistos/nbt/NBT;", "Companion"})
public final class NBTGsonWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Gson gson;
    @NotNull
    private static final Gson GsonInstance = new Gson();

    public NBTGsonWriter(@NotNull Gson gson) {
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        this.gson = gson;
    }

    public /* synthetic */ NBTGsonWriter(Gson gson, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            gson = GsonInstance;
        }
        this(gson);
    }

    @NotNull
    public final Gson getGson() {
        return this.gson;
    }

    @NotNull
    public final JsonElement write(@NotNull NBT element) {
        JsonElement jsonElement;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        NBT nBT = element;
        if (nBT instanceof NBTNumber) {
            jsonElement = (JsonElement)new JsonPrimitive(((NBTNumber)element).getValue());
        } else if (nBT instanceof NBTString) {
            jsonElement = (JsonElement)new JsonPrimitive(((NBTString)element).getValue());
        } else if (nBT instanceof NBTByteArray) {
            JsonArray jsonArray = new JsonArray();
            boolean bl = false;
            boolean bl2 = false;
            JsonArray $this$write_u24lambda_u2d1 = jsonArray;
            boolean bl3 = false;
            Iterable $this$forEach$iv = (Iterable)element;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                byte it = ((Number)element$iv).byteValue();
                boolean bl4 = false;
                $this$write_u24lambda_u2d1.add((Number)it);
            }
            jsonElement = (JsonElement)jsonArray;
        } else if (nBT instanceof NBTLongArray) {
            JsonArray jsonArray = new JsonArray();
            boolean bl = false;
            boolean bl5 = false;
            JsonArray $this$write_u24lambda_u2d3 = jsonArray;
            boolean bl6 = false;
            Iterable $this$forEach$iv = (Iterable)element;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                long it = ((Number)element$iv).longValue();
                boolean bl7 = false;
                $this$write_u24lambda_u2d3.add((Number)it);
            }
            jsonElement = (JsonElement)jsonArray;
        } else if (nBT instanceof NBTIntArray) {
            JsonArray jsonArray = new JsonArray();
            boolean bl = false;
            boolean bl8 = false;
            JsonArray $this$write_u24lambda_u2d5 = jsonArray;
            boolean bl9 = false;
            Iterable $this$forEach$iv = (Iterable)element;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl10 = false;
                $this$write_u24lambda_u2d5.add((Number)it);
            }
            jsonElement = (JsonElement)jsonArray;
        } else if (nBT instanceof NBTList) {
            JsonArray jsonArray = new JsonArray();
            boolean bl = false;
            boolean bl11 = false;
            JsonArray $this$write_u24lambda_u2d7 = jsonArray;
            boolean bl12 = false;
            Iterable $this$forEach$iv = (Iterable)element;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NBT it = (NBT)element$iv;
                boolean bl13 = false;
                $this$write_u24lambda_u2d7.add(this.write(it));
            }
            jsonElement = (JsonElement)jsonArray;
        } else if (nBT instanceof NBTCompound) {
            JsonObject jsonObject = new JsonObject();
            boolean bl = false;
            boolean bl14 = false;
            JsonObject $this$write_u24lambda_u2d8 = jsonObject;
            boolean bl15 = false;
            Iterator iterator = ((NBTCompound)element).iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = (Map.Entry)iterator.next();
                boolean bl16 = false;
                String name = (String)entry2.getKey();
                Map.Entry entry3 = entry;
                boolean bl17 = false;
                NBT value = (NBT)entry3.getValue();
                $this$write_u24lambda_u2d8.add(name, this.write(value));
            }
            jsonElement = (JsonElement)jsonObject;
        } else {
            if (nBT instanceof NBTEnd) {
                throw new NBTException("Cannot convert TAG_End to a JsonElement", null, 2, null);
            }
            String string = "Cannot serialize type " + element.getID() + ", not supported by this writer";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return jsonElement;
    }

    public NBTGsonWriter() {
        this(null, 1, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final NBTGsonWriter writer(@NotNull Gson gson) {
        return Companion.writer(gson);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final NBTGsonWriter writer() {
        return Companion.writer();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0004H\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jglrxavpok/hephaistos/json/NBTGsonWriter$Companion;", "", "()V", "GsonInstance", "Lcom/google/gson/Gson;", "getGsonInstance", "()Lcom/google/gson/Gson;", "writer", "Lorg/jglrxavpok/hephaistos/json/NBTGsonWriter;", "gson"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Gson getGsonInstance() {
            return GsonInstance;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final NBTGsonWriter writer(@NotNull Gson gson) {
            Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
            return new NBTGsonWriter(gson);
        }

        public static /* synthetic */ NBTGsonWriter writer$default(Companion companion, Gson gson, int n, Object object) {
            if ((n & 1) != 0) {
                gson = companion.getGsonInstance();
            }
            return companion.writer(gson);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final NBTGsonWriter writer() {
            return org.jglrxavpok.hephaistos.json.NBTGsonWriter$Companion.writer$default(this, null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

